/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.codeInspection.naming.NamingConventionWithFallbackBean;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.SyntheticElement;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNamingConventionInspection<T extends PsiNameIdentifierOwner>
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AbstractNamingConventionInspection.class);
    private final Map<String, NamingConvention<T>> myNamingConventions = new LinkedHashMap<String, NamingConvention<T>>();
    private final Map<String, NamingConventionBean> myNamingConventionBeans = new LinkedHashMap<String, NamingConventionBean>();
    private final Map<String, Element> myUnloadedElements = new LinkedHashMap<String, Element>();
    private final Set<String> myDisabledShortNames = new HashSet<String>();
    @Nullable
    private final String myDefaultConventionShortName;

    protected AbstractNamingConventionInspection(Iterable<NamingConvention<T>> extensions, @Nullable String defaultConventionShortName) {
        for (NamingConvention<T> convention : extensions) {
            String shortName = convention.getShortName();
            NamingConvention<T> oldConvention = this.myNamingConventions.put(shortName, convention);
            if (oldConvention != null) {
                LOG.error("Duplicated short names: " + shortName + " first: " + oldConvention + "; second: " + convention);
            }
            this.myNamingConventionBeans.put(shortName, convention.createDefaultBean());
        }
        this.initDisabledState();
        this.myDefaultConventionShortName = defaultConventionShortName;
    }

    @Nullable
    protected abstract LocalQuickFix createRenameFix();

    private void initDisabledState() {
        this.myDisabledShortNames.clear();
        for (NamingConvention<T> convention : this.myNamingConventions.values()) {
            if (convention.isEnabledByDefault()) continue;
            this.myDisabledShortNames.add(convention.getShortName());
        }
    }

    public NamingConventionBean getNamingConventionBean(String shortName) {
        return this.myNamingConventionBeans.get(shortName);
    }

    public Set<String> getOldToolNames() {
        return this.myNamingConventions.keySet();
    }

    @NotNull
    protected String createErrorMessage(String name, String shortName) {
        String string = this.myNamingConventions.get(shortName).createErrorMessage(name, this.myNamingConventionBeans.get(shortName));
        if (string == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(1);
        }
        this.initDisabledState();
        for (Element extension : node.getChildren("extension")) {
            String shortName = extension.getAttributeValue("name");
            if (shortName == null) continue;
            NamingConventionBean conventionBean = this.myNamingConventionBeans.get(shortName);
            if (conventionBean == null) {
                this.myUnloadedElements.put(shortName, extension);
                continue;
            }
            try {
                XmlSerializer.deserializeInto((Object)conventionBean, (Element)extension);
                conventionBean.initPattern();
            }
            catch (XmlSerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
            String enabled = extension.getAttributeValue("enabled");
            if (!Boolean.parseBoolean(enabled)) continue;
            this.myDisabledShortNames.remove(shortName);
        }
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(2);
        }
        TreeSet<String> shortNames = new TreeSet<String>(this.myNamingConventions.keySet());
        shortNames.addAll(this.myUnloadedElements.keySet());
        for (String shortName : shortNames) {
            NamingConvention<T> convention = this.myNamingConventions.get(shortName);
            if (convention == null) {
                Element element = this.myUnloadedElements.get(shortName);
                if (element == null) continue;
                node.addContent(element.clone());
                continue;
            }
            boolean disabled = this.myDisabledShortNames.contains(shortName);
            Element element = new Element("extension").setAttribute("name", shortName).setAttribute("enabled", disabled ? "false" : "true");
            NamingConventionBean conventionBean = this.myNamingConventionBeans.get(shortName);
            if (!convention.createDefaultBean().equals(conventionBean)) {
                XmlSerializer.serializeInto((Object)conventionBean, (Element)element);
            } else if (disabled) continue;
            node.addContent(element);
        }
    }

    public boolean isConventionEnabled(String shortName) {
        return !this.myDisabledShortNames.contains(shortName);
    }

    protected void checkName(@NotNull T member, @NotNull String name, @NotNull ProblemsHolder holder) {
        if (member == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(3);
        }
        if (name == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(5);
        }
        if (member instanceof SyntheticElement) {
            return;
        }
        this.checkName(member, shortName -> {
            LocalQuickFix[] fixes;
            if (holder == null) {
                AbstractNamingConventionInspection.$$$reportNull$$$0(8);
            }
            if (member == null) {
                AbstractNamingConventionInspection.$$$reportNull$$$0(9);
            }
            if (name == null) {
                AbstractNamingConventionInspection.$$$reportNull$$$0(10);
            }
            if (holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fix = this.createRenameFix();
                if (fix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = fix;
                } else {
                    localQuickFixArray = null;
                }
                fixes = localQuickFixArray;
            } else {
                fixes = null;
            }
            PsiElement element = (PsiElement)ObjectUtils.notNull((Object)member.getNameIdentifier(), (Object)member);
            if (!element.isPhysical()) {
                element = element.getNavigationElement();
            }
            holder.registerProblem(element, this.createErrorMessage(name, (String)shortName), fixes);
        });
    }

    protected void checkName(@NotNull T member, @NotNull Consumer<String> errorRegister) {
        if (member == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(6);
        }
        if (errorRegister == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(7);
        }
        for (NamingConvention<T> namingConvention : this.myNamingConventions.values()) {
            if (!namingConvention.isApplicable(member)) continue;
            String shortName = namingConvention.getShortName();
            if (this.myDisabledShortNames.contains(shortName)) break;
            NamingConventionBean activeBean = this.myNamingConventionBeans.get(shortName);
            if (activeBean instanceof NamingConventionWithFallbackBean && ((NamingConventionWithFallbackBean)activeBean).isInheritDefaultSettings()) {
                LOG.assertTrue(this.myDefaultConventionShortName != null, (Object)(activeBean + " expects that default conversion is configured"));
                shortName = this.myDefaultConventionShortName;
                if (this.myDisabledShortNames.contains(shortName)) break;
                activeBean = this.myNamingConventionBeans.get(shortName);
                namingConvention = this.myNamingConventions.get(shortName);
            }
            if (namingConvention.isValid(member, activeBean)) break;
            errorRegister.accept(shortName);
            break;
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(JBUI.scale((int)2), JBUI.scale((int)2)));
        CardLayout layout = new CardLayout();
        final JPanel descriptionPanel = new JPanel(layout);
        descriptionPanel.setBorder(JBUI.Borders.empty((int)2));
        panel2.add((Component)descriptionPanel, "Center");
        CheckBoxList list2 = new CheckBoxList();
        list2.setBorder(JBUI.Borders.empty((int)2));
        final ArrayList<NamingConvention<T>> values = new ArrayList<NamingConvention<T>>(this.myNamingConventions.values());
        Collections.reverse(values);
        for (NamingConvention namingConvention : values) {
            String shortName = namingConvention.getShortName();
            list2.addItem((Object)namingConvention, namingConvention.getElementDescription(), !this.myDisabledShortNames.contains(shortName));
            descriptionPanel.add((Component)this.myNamingConventionBeans.get(shortName).createOptionsPanel(), shortName);
        }
        list2.addListSelectionListener(e -> {
            int selectedIndex = list2.getSelectedIndex();
            NamingConvention item = (NamingConvention)list2.getItemAt(selectedIndex);
            if (item != null) {
                String shortName = item.getShortName();
                layout.show(descriptionPanel, shortName);
                UIUtil.setEnabled((Component)descriptionPanel, (boolean)list2.isItemSelected(selectedIndex), (boolean)true);
            }
        });
        list2.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                NamingConvention convention = (NamingConvention)values.get(index);
                AbstractNamingConventionInspection.this.setEnabled(value, convention.getShortName());
                UIUtil.setEnabled((Component)descriptionPanel, (boolean)value, (boolean)true);
            }
        });
        list2.setSelectedIndex(0);
        panel2.add((Component)new JBScrollPane((Component)list2), "West");
        return panel2;
    }

    public void setEnabled(boolean value, String conventionShortName) {
        if (value) {
            this.myDisabledShortNames.remove(conventionShortName);
        } else {
            this.myDisabledShortNames.add(conventionShortName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/naming/AbstractNamingConventionInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorRegister";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/naming/AbstractNamingConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

