/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefFileImpl
extends RefElementImpl
implements RefFile {
    RefFileImpl(PsiFile elem, RefManager manager) {
        this(elem, manager, true);
    }

    protected RefFileImpl(PsiFile elem, RefManager manager, boolean addParent) {
        super(elem, manager);
        RefElement element;
        if (!addParent) {
            return;
        }
        VirtualFile vFile = elem.getVirtualFile();
        if (vFile == null) {
            return;
        }
        VirtualFile parentDirectory = vFile.getParent();
        if (parentDirectory == null) {
            return;
        }
        PsiDirectory psiDirectory = elem.getManager().findDirectory(parentDirectory);
        if (psiDirectory != null && (element = this.getRefManager().getReference((PsiElement)psiDirectory)) != null) {
            ((RefElementImpl)element).add(this);
        }
    }

    public PsiFile getElement() {
        return (PsiFile)super.getElement();
    }

    @Override
    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefFileImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (visitor2 == null) {
                RefFileImpl.$$$reportNull$$$0(1);
            }
            visitor2.visitFile((RefFile)this);
        });
    }

    @Override
    public String getExternalName() {
        PsiFile psiFile = this.getElement();
        VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        return virtualFile != null ? virtualFile.getUrl() : this.getName();
    }

    @Override
    protected void initialize() {
    }

    @Nullable
    static RefElement fileFromExternalName(RefManager manager, String fqName) {
        PsiFile psiFile;
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(PathMacroManager.getInstance((ComponentManager)manager.getProject()).expandPath(fqName));
        if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)manager.getProject()).findFile(virtualFile)) != null) {
            return manager.getReference((PsiElement)psiFile);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "visitor";
        objectArray2[1] = "com/intellij/codeInspection/reference/RefFileImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$accept$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

