/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeCellRenderer;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionTreeState;
import com.intellij.codeInspection.ui.InspectionTreeUpdater;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTree
extends Tree {
    private static final Logger LOG = Logger.getInstance(InspectionTree.class);
    @NotNull
    private final GlobalInspectionContextImpl myContext;
    @NotNull
    private final ConcurrentMap<HighlightDisplayLevel, InspectionSeverityGroupNode> mySeverityGroupNodes;
    @NotNull
    private final ConcurrentMap<HighlightDisplayLevel, ConcurrentMap<String[], InspectionGroupNode>> myGroups;
    @NotNull
    private InspectionTreeState myState;
    private boolean myQueueUpdate;

    public InspectionTree(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionResultsView view) {
        if (context == null) {
            InspectionTree.$$$reportNull$$$0(0);
        }
        if (view == null) {
            InspectionTree.$$$reportNull$$$0(1);
        }
        this.mySeverityGroupNodes = ContainerUtil.newConcurrentMap();
        this.myGroups = ContainerUtil.newConcurrentMap();
        this.myState = new InspectionTreeState();
        Project project = context.getProject();
        this.setModel(new DefaultTreeModel(new InspectionRootNode(project, new InspectionTreeUpdater(view))));
        this.myContext = context;
        this.setCellRenderer((TreeCellRenderer)((Object)new InspectionTreeCellRenderer(view)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)((Object)this));
        this.addTreeWillExpandListener(new ExpandListener());
        this.myState.getExpandedUserObjects().add(project);
        TreeUtil.installActions((JTree)((Object)this));
        new TreeSpeedSearch(this, (Convertor<TreePath, String>)((Convertor)o -> InspectionsConfigTreeComparator.getDisplayTextToSort(o.getLastPathComponent().toString())));
        this.addTreeSelectionListener(e -> {
            TreePath newSelection = e.getNewLeadSelectionPath();
            if (newSelection != null && !this.isUnderQueueUpdate()) {
                this.myState.setSelectionPath(newSelection);
            }
        });
    }

    public void setQueueUpdate(boolean queueUpdate) {
        this.myQueueUpdate = queueUpdate;
    }

    public boolean isUnderQueueUpdate() {
        return this.myQueueUpdate;
    }

    public void removeAllNodes() {
        this.mySeverityGroupNodes.clear();
        this.myGroups.clear();
        this.getRoot().removeAllChildren();
        ApplicationManager.getApplication().invokeLater(() -> {
            InspectionResultsView view = this.myContext.getView();
            if (view != null && !view.isDisposed()) {
                this.nodeStructureChanged(this.getRoot());
            }
        });
    }

    public InspectionTreeNode getRoot() {
        return (InspectionTreeNode)this.getModel().getRoot();
    }

    @Nullable
    public String[] getSelectedGroupPath() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        TreePath commonPath = TreeUtil.findCommonPath((TreePath[])paths);
        for (Object n : commonPath.getPath()) {
            if (!(n instanceof InspectionGroupNode)) continue;
            return InspectionTree.getGroupPath((InspectionGroupNode)n);
        }
        return null;
    }

    @Nullable
    public InspectionToolWrapper getSelectedToolWrapper(boolean allowDummy) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        InspectionToolWrapper toolWrapper = null;
        block0: for (TreePath path : paths) {
            Object[] nodes = path.getPath();
            for (int j = nodes.length - 1; j >= 0; --j) {
                Object node = nodes[j];
                if (node instanceof InspectionGroupNode) {
                    return null;
                }
                if (!(node instanceof InspectionNode)) continue;
                InspectionToolWrapper wrapper2 = ((InspectionNode)node).getToolWrapper();
                if (!allowDummy && this.getContext().getPresentation(wrapper2).isDummy()) continue;
                if (toolWrapper == null) {
                    toolWrapper = wrapper2;
                    continue block0;
                }
                if (toolWrapper == wrapper2) continue block0;
                return null;
            }
        }
        return toolWrapper;
    }

    public String getToolTipText(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return null;
        }
        Object lastComponent = path.getLastPathComponent();
        if (!(lastComponent instanceof ProblemDescriptionNode)) {
            return null;
        }
        return ((ProblemDescriptionNode)lastComponent).getToolTipText();
    }

    @Nullable
    public RefEntity getCommonSelectedElement() {
        Object node = this.getCommonSelectedNode();
        return node instanceof RefElementNode ? ((RefElementNode)node).getElement() : null;
    }

    @Nullable
    private Object getCommonSelectedNode() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        Object[][] resolvedPaths = new Object[paths.length][];
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            resolvedPaths[i] = path.getPath();
        }
        Object currentCommonNode = null;
        for (int i = 0; i < resolvedPaths[0].length; ++i) {
            Object currentNode = resolvedPaths[0][i];
            for (int j = 1; j < resolvedPaths.length; ++j) {
                Object o = resolvedPaths[j][i];
                if (o.equals(currentNode)) continue;
                return currentCommonNode;
            }
            currentCommonNode = currentNode;
        }
        return currentCommonNode;
    }

    @NotNull
    public RefEntity[] getSelectedElements() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            InspectionToolWrapper toolWrapper = this.getSelectedToolWrapper(true);
            if (toolWrapper == null) {
                if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                    InspectionTree.$$$reportNull$$$0(2);
                }
                return RefEntity.EMPTY_ELEMENTS_ARRAY;
            }
            LinkedHashSet<RefEntity> result2 = new LinkedHashSet<RefEntity>();
            for (TreePath selectionPath : selectionPaths) {
                InspectionTreeNode node = (InspectionTreeNode)selectionPath.getLastPathComponent();
                InspectionTree.addElementsInNode(node, result2);
            }
            RefEntity[] refEntityArray = (RefEntity[])ArrayUtil.reverseArray((Object[])result2.toArray(RefEntity.EMPTY_ELEMENTS_ARRAY));
            if (refEntityArray == null) {
                InspectionTree.$$$reportNull$$$0(3);
            }
            return refEntityArray;
        }
        if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
            InspectionTree.$$$reportNull$$$0(4);
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    private static void addElementsInNode(InspectionTreeNode node, Set<RefEntity> out) {
        RefEntity element;
        if (!node.isValid()) {
            return;
        }
        if (node instanceof RefElementNode) {
            element = ((RefElementNode)node).getElement();
            out.add(element);
        }
        if (node instanceof ProblemDescriptionNode) {
            element = ((ProblemDescriptionNode)node).getElement();
            out.add(element);
        }
        Enumeration<TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)children2.nextElement();
            InspectionTree.addElementsInNode(child, out);
        }
    }

    @NotNull
    public CommonProblemDescriptor[] getAllValidSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, true));
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(5);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public CommonProblemDescriptor[] getSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = BatchModeDescriptorsUtil.flattenDescriptors(this.getSelectedDescriptorPacks(false, null, false));
        if (commonProblemDescriptorArray == null) {
            InspectionTree.$$$reportNull$$$0(6);
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public List<CommonProblemDescriptor[]> getSelectedDescriptorPacks(boolean sortedByPosition, @Nullable Set<VirtualFile> readOnlyFilesSink, boolean allowResolved) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            List<CommonProblemDescriptor[]> list2 = Collections.emptyList();
            if (list2 == null) {
                InspectionTree.$$$reportNull$$$0(7);
            }
            return list2;
        }
        MultiMap parentToChildNode = new MultiMap();
        ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)((Object)this)).withRoots(Arrays.asList(paths))).traverse().map(p -> p.getLastPathComponent()).filter(ProblemDescriptionNode.class).filter(node -> node.getDescriptor() != null && InspectionTree.isNodeValidAndIncluded(node, allowResolved)).consumeEach(node -> {
            Object key = InspectionTree.getVirtualFileOrEntity(node.getElement());
            parentToChildNode.putValue(key, (Object)node.getDescriptor());
        });
        ArrayList<CommonProblemDescriptor[]> descriptors = new ArrayList<CommonProblemDescriptor[]>();
        for (Map.Entry entry : parentToChildNode.entrySet()) {
            Object key = entry.getKey();
            if (readOnlyFilesSink != null && key instanceof VirtualFile && !((VirtualFile)key).isWritable()) {
                readOnlyFilesSink.add((VirtualFile)key);
            }
            Stream stream = ((Collection)entry.getValue()).stream();
            if (sortedByPosition) {
                stream = stream.sorted(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            descriptors.add((CommonProblemDescriptor[])stream.toArray(arg_0 -> ((ArrayFactory)CommonProblemDescriptor.ARRAY_FACTORY).create(arg_0)));
        }
        ArrayList<CommonProblemDescriptor[]> arrayList = descriptors;
        if (arrayList == null) {
            InspectionTree.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    InspectionTreeNode getToolParentNode(@NotNull InspectionToolWrapper toolWrapper, HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        InspectionGroupNode group;
        if (toolWrapper == null) {
            InspectionTree.$$$reportNull$$$0(9);
        }
        if (!groupedBySeverity && isSingleInspectionRun) {
            InspectionTreeNode inspectionTreeNode = this.getRoot();
            if (inspectionTreeNode == null) {
                InspectionTree.$$$reportNull$$$0(10);
            }
            return inspectionTreeNode;
        }
        String[] groupPath = toolWrapper.getGroupPath();
        if (groupPath.length == 0) {
            LOG.error("groupPath is empty for tool: " + toolWrapper.getShortName() + ", class: " + toolWrapper.getTool().getClass());
            InspectionTreeNode inspectionTreeNode = this.getRelativeRootNode(groupedBySeverity, errorLevel);
            if (inspectionTreeNode == null) {
                InspectionTree.$$$reportNull$$$0(11);
            }
            return inspectionTreeNode;
        }
        ConcurrentMap map2 = (ConcurrentMap)this.myGroups.get(errorLevel);
        if (map2 == null) {
            map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myGroups, (Object)errorLevel, ConcurrentCollectionFactory.createMap(new TObjectHashingStrategy<String[]>(){

                public int computeHashCode(String[] object) {
                    return Arrays.hashCode(object);
                }

                public boolean equals(String[] o1, String[] o2) {
                    return Arrays.equals(o1, o2);
                }
            }));
        }
        if (groupedBySeverity) {
            group = (InspectionGroupNode)map2.get(groupPath);
        } else {
            Map groupMap;
            group = null;
            Iterator iterator = this.myGroups.values().iterator();
            while (iterator.hasNext() && (group = (InspectionGroupNode)(groupMap = (Map)iterator.next()).get(groupPath)) == null) {
            }
        }
        if (group == null) {
            if (isSingleInspectionRun) {
                InspectionTreeNode inspectionTreeNode = this.getRelativeRootNode(true, errorLevel);
                if (inspectionTreeNode == null) {
                    InspectionTree.$$$reportNull$$$0(12);
                }
                return inspectionTreeNode;
            }
            group = map2.computeIfAbsent(groupPath, p -> this.insertGroupNode((String[])p, this.getRelativeRootNode(groupedBySeverity, errorLevel)));
        }
        InspectionGroupNode inspectionGroupNode = group;
        if (inspectionGroupNode == null) {
            InspectionTree.$$$reportNull$$$0(13);
        }
        return inspectionGroupNode;
    }

    @NotNull
    private InspectionTreeNode getRelativeRootNode(boolean isGroupedBySeverity, HighlightDisplayLevel level) {
        if (isGroupedBySeverity) {
            InspectionSeverityGroupNode newNode;
            InspectionSeverityGroupNode severityGroupNode = (InspectionSeverityGroupNode)this.mySeverityGroupNodes.get(level);
            if (severityGroupNode == null && (severityGroupNode = (InspectionSeverityGroupNode)ConcurrencyUtil.cacheOrGet(this.mySeverityGroupNodes, (Object)level, (Object)(newNode = new InspectionSeverityGroupNode(this.myContext.getCurrentProfile().getProfileManager().getSeverityRegistrar(), level)))) == newNode) {
                InspectionTreeNode root = this.getRoot();
                root.insertByOrder(severityGroupNode, false);
            }
            InspectionSeverityGroupNode inspectionSeverityGroupNode = severityGroupNode;
            if (inspectionSeverityGroupNode == null) {
                InspectionTree.$$$reportNull$$$0(14);
            }
            return inspectionSeverityGroupNode;
        }
        InspectionTreeNode inspectionTreeNode = this.getRoot();
        if (inspectionTreeNode == null) {
            InspectionTree.$$$reportNull$$$0(15);
        }
        return inspectionTreeNode;
    }

    public boolean areDescriptorNodesSelected() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            if (path.getLastPathComponent() instanceof ProblemDescriptionNode) continue;
            return false;
        }
        return true;
    }

    public int getSelectedProblemCount(boolean allowSuppressed) {
        int count = 0;
        for (TreePath path : TreeUtil.selectMaximals((TreePath[])this.getSelectionPaths())) {
            count += ((InspectionTreeNode)path.getLastPathComponent()).getProblemCount(allowSuppressed);
        }
        return count;
    }

    private static boolean isNodeValidAndIncluded(ProblemDescriptionNode node, boolean allowResolved) {
        return node.isValid() && (allowResolved || !node.isExcluded() && !node.isAlreadySuppressedFromView() && !node.isQuickFixAppliedFromView());
    }

    private void nodeStructureChanged(InspectionTreeNode node) {
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
    }

    public void queueUpdate() {
        ((InspectionRootNode)this.getRoot()).getUpdater().update(true);
    }

    public void restoreExpansionAndSelection(boolean treeNodesMightChange) {
        this.myState.restoreExpansionAndSelection(this, treeNodesMightChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedProblems() {
        Object object = this.getContext().getView().getTreeStructureUpdateLock();
        synchronized (object) {
            TreePath[] selected = this.getSelectionPaths();
            if (selected == null) {
                return;
            }
            THashSet processedNodes = new THashSet();
            ArrayList<InspectionTreeNode> toRemove2 = new ArrayList<InspectionTreeNode>();
            ArrayList<TreePath> pathsToSelect = new ArrayList<TreePath>();
            block3: for (TreePath path : selected) {
                InspectionTreeNode node;
                Object[] nodePath = path.getPath();
                for (int i = 1; i < nodePath.length && processedNodes.add(node = (InspectionTreeNode)nodePath[i]); ++i) {
                    if (!this.shouldDelete(node)) continue;
                    toRemove2.add(node);
                    TreePath toSelect2 = InspectionTree.getParentPath(path, nodePath.length - i);
                    if (toSelect2 == null) continue block3;
                    pathsToSelect.add(toSelect2);
                    continue block3;
                }
            }
            if (toRemove2.isEmpty()) {
                return;
            }
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            for (InspectionTreeNode node : toRemove2) {
                TreeNode parent = node.getParent();
                if (parent == null) continue;
                model.removeNodeFromParent(node);
            }
            TreeUtil.selectPath((JTree)((Object)this), (TreePath)TreeUtil.findCommonPath((TreePath[])pathsToSelect.toArray(new TreePath[0])));
        }
        this.revalidate();
        this.repaint();
    }

    private static TreePath getParentPath(TreePath path, int ord) {
        TreePath parent = path;
        for (int j = 0; j < ord; ++j) {
            parent = parent.getParentPath();
        }
        return parent;
    }

    private boolean shouldDelete(InspectionTreeNode node) {
        if (node instanceof RefElementNode) {
            RefElementNode refElementNode = (RefElementNode)node;
            RefEntity refEntity = refElementNode.getElement();
            if (refEntity == null || InspectionTree.isEntityExcludedOrResolvedRecursively(refEntity, refElementNode.getPresentation())) {
                return true;
            }
        } else if (node instanceof ProblemDescriptionNode) {
            ProblemDescriptionNode problemDescriptionNode = (ProblemDescriptionNode)node;
            CommonProblemDescriptor descriptor2 = problemDescriptionNode.getDescriptor();
            InspectionToolPresentation presentation = problemDescriptionNode.getPresentation();
            if (descriptor2 == null || presentation.isExcluded(descriptor2) || presentation.isProblemResolved(descriptor2)) {
                return true;
            }
        } else {
            if (node instanceof InspectionGroupNode || node instanceof InspectionSeverityGroupNode || node instanceof InspectionModuleNode || node instanceof InspectionPackageNode) {
                return IntStream.range(0, node.getChildCount()).mapToObj(i -> (InspectionTreeNode)node.getChildAt(i)).allMatch(this::shouldDelete);
            }
            if (node instanceof InspectionNode) {
                InspectionToolPresentation presentation = this.myContext.getPresentation(((InspectionNode)node).getToolWrapper());
                SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> problemElements = presentation.getProblemElements();
                if (problemElements.isEmpty()) {
                    return true;
                }
                return problemElements.keys().stream().allMatch(entity -> presentation.isExcluded((RefEntity)entity));
            }
        }
        return false;
    }

    private static boolean isEntityExcludedOrResolvedRecursively(RefEntity key, InspectionToolPresentation presentation) {
        if (presentation.isProblemResolved(key) || presentation.isExcluded(key) || presentation.isSuppressed(key)) {
            return true;
        }
        List children2 = key.getChildren();
        return !children2.isEmpty() && children2.stream().allMatch(entity -> InspectionTree.isEntityExcludedOrResolvedRecursively(entity, presentation));
    }

    public InspectionTreeState getTreeState() {
        return this.myState;
    }

    public void setTreeState(@NotNull InspectionTreeState treeState) {
        if (treeState == null) {
            InspectionTree.$$$reportNull$$$0(16);
        }
        this.myState = treeState;
    }

    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myContext;
        if (globalInspectionContextImpl == null) {
            InspectionTree.$$$reportNull$$$0(17);
        }
        return globalInspectionContextImpl;
    }

    private InspectionGroupNode insertGroupNode(@NotNull String[] groupPath, InspectionTreeNode parent) {
        if (groupPath == null) {
            InspectionTree.$$$reportNull$$$0(18);
        }
        InspectionTreeNode currentNode = parent;
        for (int groupIdx = 0; groupIdx < groupPath.length; ++groupIdx) {
            int i;
            String subGroup = groupPath[groupIdx];
            InspectionTreeNode next = null;
            for (i = 0; i < currentNode.getChildCount(); ++i) {
                TreeNode child = currentNode.getChildAt(i);
                if (!(child instanceof InspectionGroupNode) || !((InspectionGroupNode)child).getSubGroup().equals(subGroup)) continue;
                next = (InspectionTreeNode)child;
                break;
            }
            if (next == null) {
                for (i = groupIdx; i < groupPath.length; ++i) {
                    InspectionResultsView view = this.getContext().getView();
                    if (view == null || view.isDisposed()) continue;
                    currentNode = currentNode.insertByOrder(new InspectionGroupNode(groupPath[i]), false);
                }
                break;
            }
            currentNode = next;
        }
        return (InspectionGroupNode)currentNode;
    }

    @NotNull
    private static String[] getGroupPath(@NotNull InspectionGroupNode node) {
        TreeNode parent;
        if (node == null) {
            InspectionTree.$$$reportNull$$$0(19);
        }
        ArrayList<String> path = new ArrayList<String>(2);
        while ((parent = node.getParent()) instanceof InspectionGroupNode) {
            node = (InspectionGroupNode)parent;
            path.add(node.getSubGroup());
        }
        String[] stringArray = ArrayUtil.toStringArray(path);
        if (stringArray == null) {
            InspectionTree.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    @Nullable
    private static Object getVirtualFileOrEntity(@Nullable RefEntity entity) {
        VirtualFile file2;
        SmartPsiElementPointer pointer;
        if (entity instanceof RefElement && (pointer = ((RefElement)entity).getPointer()) != null && (file2 = pointer.getVirtualFile()) != null) {
            return file2;
        }
        return entity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeState";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTree";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValidSelectedDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDescriptorPacks";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolParentNode";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeRootNode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getToolParentNode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTreeState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertGroupNode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getGroupPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExpandListener
    implements TreeWillExpandListener {
        private ExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) {
            InspectionTreeNode node = (InspectionTreeNode)event.getPath().getLastPathComponent();
            InspectionTree.this.myState.getExpandedUserObjects().add(node.getUserObject());
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) {
            InspectionTreeNode node = (InspectionTreeNode)event.getPath().getLastPathComponent();
            InspectionTree.this.myState.getExpandedUserObjects().remove(node.getUserObject());
        }
    }
}

