/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBRunnerTabs
extends JBEditorTabs {
    public JBRunnerTabs(@Nullable Project project, @NotNull ActionManager actionManager, IdeFocusManager focusManager, @NotNull Disposable parent) {
        if (actionManager == null) {
            JBRunnerTabs.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            JBRunnerTabs.$$$reportNull$$$0(1);
        }
        super(project, actionManager, focusManager, parent);
    }

    public boolean useSmallLabels() {
        return true;
    }

    public int getToolbarInset() {
        return 0;
    }

    public int tabMSize() {
        return 8;
    }

    public boolean shouldAddToGlobal(Point point) {
        TabLabel label2 = this.getSelectedLabel();
        if (label2 == null || point == null) {
            return true;
        }
        Rectangle bounds = label2.getBounds();
        return point.y <= bounds.y + bounds.height;
    }

    public Rectangle layout(JComponent c, Rectangle bounds) {
        if (c instanceof JBTabsImpl.Toolbar) {
            bounds.height -= 5;
            return super.layout(c, bounds);
        }
        return super.layout(c, bounds);
    }

    public void processDropOver(TabInfo over, RelativePoint relativePoint) {
        Point point = relativePoint.getPoint((Component)this.getComponent());
        this.myShowDropLocation = this.shouldAddToGlobal(point);
        super.processDropOver(over, relativePoint);
        for (Map.Entry entry : this.myInfo2Label.entrySet()) {
            TabLabel label2 = (TabLabel)entry.getValue();
            if (!label2.getBounds().contains(point) || this.myDropInfo == entry.getKey()) continue;
            this.select((TabInfo)entry.getKey(), false);
            break;
        }
    }

    protected Color getEmptySpaceColor() {
        return UIUtil.getBgFillColor((Component)this.getParent());
    }

    protected TabLabel createTabLabel(TabInfo info) {
        return new MyTabLabel((JBTabsImpl)this, info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "actionManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/ui/layout/impl/JBRunnerTabs";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyTabLabel
    extends TabLabel {
        public MyTabLabel(JBTabsImpl tabs2, TabInfo info) {
            super(tabs2, info);
        }

        public void apply(UiDecorator.UiDecoration decoration) {
            this.setBorder(new EmptyBorder(5, 5, 7, 5));
        }

        public void setTabActionsAutoHide(boolean autoHide) {
            super.setTabActionsAutoHide(autoHide);
            this.apply(null);
        }

        public void setTabActions(ActionGroup group) {
            super.setTabActions(group);
            if (this.myActionPanel != null) {
                JComponent wrapper2 = (JComponent)this.myActionPanel.getComponent(0);
                wrapper2.remove(0);
                wrapper2.add(Box.createHorizontalStrut(6), "West");
            }
        }

        public Dimension getPreferredSize() {
            Dimension result2 = super.getPreferredSize();
            result2.height += this.myTabs.getActiveTabUnderlineHeight() - 1;
            return result2;
        }
    }
}

