/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingStateId;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattingProgressTask
extends SequentialModalProgressTask
implements FormattingProgressCallback {
    public static final ThreadLocal<Boolean> FORMATTING_CANCELLED_FLAG = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final double MAX_PROGRESS_VALUE = 1.0;
    private static final double TOTAL_WEIGHT = Arrays.stream(FormattingStateId.values()).mapToDouble(FormattingStateId::getProgressWeight).sum();
    private final ConcurrentMap<FormattingProgressCallback.EventType, Collection<Runnable>> myCallbacks;
    private final WeakReference<VirtualFile> myFile;
    private final WeakReference<Document> myDocument;
    private final int myFileTextLength;
    @NotNull
    private FormattingStateId myLastState;
    private long myDocumentModificationStampBefore;
    private int myBlocksToModifyNumber;
    private int myModifiedBlocksNumber;

    public FormattingProgressTask(@Nullable Project project, @NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(0);
        }
        if (document == null) {
            FormattingProgressTask.$$$reportNull$$$0(1);
        }
        super(project, FormattingProgressTask.getTitle(file2));
        this.myCallbacks = ContainerUtil.newConcurrentMap();
        this.myLastState = FormattingStateId.WRAPPING_BLOCKS;
        this.myDocumentModificationStampBefore = -1L;
        this.myFile = new WeakReference<VirtualFile>(file2.getVirtualFile());
        this.myDocument = new WeakReference<Document>(document);
        this.myFileTextLength = file2.getTextLength();
        this.addCallback(FormattingProgressCallback.EventType.CANCEL, new MyCancelCallback());
    }

    @NotNull
    private static String getTitle(@NotNull PsiFile file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(2);
        }
        if ((virtualFile = file2.getOriginalFile().getVirtualFile()) == null) {
            String string = CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
            if (string == null) {
                FormattingProgressTask.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = CodeInsightBundle.message((String)"reformat.progress.file.with.known.name.text", (Object[])new Object[]{virtualFile.getName()});
        if (string == null) {
            FormattingProgressTask.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected void prepare(@NotNull SequentialTask task2) {
        if (task2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(5);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            Document document;
            if (task2 == null) {
                FormattingProgressTask.$$$reportNull$$$0(16);
            }
            if ((document = (Document)this.myDocument.get()) != null) {
                this.myDocumentModificationStampBefore = document.getModificationStamp();
            }
            task2.prepare();
        });
    }

    @Override
    public boolean addCallback(@NotNull FormattingProgressCallback.EventType eventType, @NotNull Runnable callback2) {
        if (eventType == null) {
            FormattingProgressTask.$$$reportNull$$$0(6);
        }
        if (callback2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(7);
        }
        return this.getCallbacks(eventType).add(callback2);
    }

    public void onSuccess() {
        for (Runnable callback2 : this.getCallbacks(FormattingProgressCallback.EventType.SUCCESS)) {
            callback2.run();
        }
    }

    public void onCancel() {
        for (Runnable callback2 : this.getCallbacks(FormattingProgressCallback.EventType.CANCEL)) {
            callback2.run();
        }
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            FormattingProgressTask.$$$reportNull$$$0(8);
        }
        super.onThrowable(error);
        for (Runnable callback2 : this.getCallbacks(FormattingProgressCallback.EventType.CANCEL)) {
            callback2.run();
        }
    }

    private Collection<Runnable> getCallbacks(@NotNull FormattingProgressCallback.EventType eventType) {
        Collection<Runnable> candidate;
        Collection<Runnable> result2;
        if (eventType == null) {
            FormattingProgressTask.$$$reportNull$$$0(9);
        }
        if ((result2 = (Collection<Runnable>)this.myCallbacks.get((Object)eventType)) == null && (candidate = this.myCallbacks.putIfAbsent(eventType, result2 = ContainerUtil.newConcurrentSet())) != null) {
            result2 = candidate;
        }
        return result2;
    }

    @Override
    public void afterWrappingBlock(@NotNull LeafBlockWrapper wrapped) {
        if (wrapped == null) {
            FormattingProgressTask.$$$reportNull$$$0(10);
        }
        this.update(FormattingStateId.WRAPPING_BLOCKS, 1.0 * (double)wrapped.getEndOffset() / (double)this.myFileTextLength);
    }

    @Override
    public void afterProcessingBlock(@NotNull LeafBlockWrapper block) {
        if (block == null) {
            FormattingProgressTask.$$$reportNull$$$0(11);
        }
        this.update(FormattingStateId.PROCESSING_BLOCKS, 1.0 * (double)block.getEndOffset() / (double)this.myFileTextLength);
    }

    @Override
    public void beforeApplyingFormatChanges(@NotNull Collection<LeafBlockWrapper> modifiedBlocks) {
        if (modifiedBlocks == null) {
            FormattingProgressTask.$$$reportNull$$$0(12);
        }
        this.myBlocksToModifyNumber = modifiedBlocks.size();
        this.updateTextIfNecessary(FormattingStateId.APPLYING_CHANGES);
        this.setCancelText(IdeBundle.message((String)"action.stop", (Object[])new Object[0]));
    }

    @Override
    public void afterApplyingChange(@NotNull LeafBlockWrapper block) {
        if (block == null) {
            FormattingProgressTask.$$$reportNull$$$0(13);
        }
        if (this.myModifiedBlocksNumber++ >= this.myBlocksToModifyNumber) {
            return;
        }
        this.update(FormattingStateId.APPLYING_CHANGES, 1.0 * (double)this.myModifiedBlocksNumber / (double)this.myBlocksToModifyNumber);
    }

    private void update(@NotNull FormattingStateId state2, double completionRate) {
        double currentFraction;
        ProgressIndicator indicator;
        if (state2 == null) {
            FormattingProgressTask.$$$reportNull$$$0(14);
        }
        if ((indicator = this.getIndicator()) == null) {
            return;
        }
        this.updateTextIfNecessary(state2);
        this.myLastState = state2;
        double newFraction = 0.0;
        for (FormattingStateId prevState : state2.getPreviousStates()) {
            newFraction += 1.0 * prevState.getProgressWeight() / TOTAL_WEIGHT;
        }
        if ((newFraction += completionRate * state2.getProgressWeight() / TOTAL_WEIGHT) - (currentFraction = indicator.getFraction()) < 0.01) {
            return;
        }
        indicator.setFraction(newFraction);
    }

    private void updateTextIfNecessary(@NotNull FormattingStateId currentState) {
        if (currentState == null) {
            FormattingProgressTask.$$$reportNull$$$0(15);
        }
        ProgressIndicator indicator = this.getIndicator();
        if (this.myLastState != currentState && indicator != null) {
            indicator.setText(currentState.getDescription());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/FormattingProgressTask";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapped";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedBlocks";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/FormattingProgressTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCallback";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onThrowable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCallbacks";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "afterWrappingBlock";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "afterProcessingBlock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "beforeApplyingFormatChanges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "afterApplyingChange";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateTextIfNecessary";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepare$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCancelCallback
    implements Runnable {
        private MyCancelCallback() {
        }

        @Override
        public void run() {
            FORMATTING_CANCELLED_FLAG.set(true);
            VirtualFile file2 = (VirtualFile)FormattingProgressTask.this.myFile.get();
            Document document = (Document)FormattingProgressTask.this.myDocument.get();
            if (file2 == null || document == null || FormattingProgressTask.this.myDocumentModificationStampBefore < 0L) {
                return;
            }
            FileEditor editor = FileEditorManager.getInstance((Project)FormattingProgressTask.this.myProject).getSelectedEditor(file2);
            if (editor == null) {
                return;
            }
            UndoManager manager = UndoManager.getInstance((Project)FormattingProgressTask.this.myProject);
            while (manager.isUndoAvailable(editor) && document.getModificationStamp() != FormattingProgressTask.this.myDocumentModificationStampBefore) {
                manager.undo(editor);
            }
        }
    }
}

