/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HtmlLineMarkerProvider
implements LineMarkerProvider {
    private final Map<Language, List<LineMarkerProvider>> embeddedLanguagesLineMarkerProviders = ContainerUtil.newConcurrentMap();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            HtmlLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiWhiteSpace) {
            return null;
        }
        Language language = element.getLanguage();
        if (!(language instanceof XMLLanguage)) {
            List<LineMarkerProvider> markerProviders = HtmlLineMarkerProvider.getAllLineMarkerProvidersForLanguage(language, this.embeddedLanguagesLineMarkerProviders);
            for (LineMarkerProvider provider : markerProviders) {
                LineMarkerInfo info;
                if (provider instanceof HtmlLineMarkerProvider || (info = provider.getLineMarkerInfo(element)) == null) continue;
                return info;
            }
        }
        return null;
    }

    @NotNull
    private static List<LineMarkerProvider> getAllLineMarkerProvidersForLanguage(@NotNull Language language, @NotNull Map<Language, List<LineMarkerProvider>> embeddedLanguagesLineMarkerProviders) {
        List markerProviders;
        if (language == null) {
            HtmlLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (embeddedLanguagesLineMarkerProviders == null) {
            HtmlLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((markerProviders = embeddedLanguagesLineMarkerProviders.get(language)) == null) {
            markerProviders = LineMarkerProviders.INSTANCE.allForLanguage(language);
            embeddedLanguagesLineMarkerProviders.put(language, markerProviders);
        }
        List list2 = markerProviders;
        if (list2 == null) {
            HtmlLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            HtmlLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            HtmlLineMarkerProvider.$$$reportNull$$$0(5);
        }
        THashMap localEmbeddedLanguagesLineMarkerProviders = null;
        Map embeddedLineMarkersWorkItems = null;
        for (PsiElement psiElement : elements) {
            Language language;
            if (psiElement instanceof PsiWhiteSpace || (language = psiElement.getLanguage()) instanceof XMLLanguage) continue;
            if (localEmbeddedLanguagesLineMarkerProviders == null) {
                localEmbeddedLanguagesLineMarkerProviders = new THashMap();
            }
            List<LineMarkerProvider> lineMarkerProviders = HtmlLineMarkerProvider.getAllLineMarkerProvidersForLanguage(language, localEmbeddedLanguagesLineMarkerProviders);
            for (LineMarkerProvider provider : lineMarkerProviders) {
                if (provider instanceof HtmlLineMarkerProvider) continue;
                if (embeddedLineMarkersWorkItems == null) {
                    embeddedLineMarkersWorkItems = new THashMap();
                }
                List elementList = embeddedLineMarkersWorkItems.computeIfAbsent(provider, k -> new ArrayList(5));
                elementList.add(psiElement);
            }
        }
        if (embeddedLineMarkersWorkItems != null) {
            for (Map.Entry entry : embeddedLineMarkersWorkItems.entrySet()) {
                ((LineMarkerProvider)entry.getKey()).collectSlowLineMarkers((List)entry.getValue(), result2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedLanguagesLineMarkerProviders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/html/HtmlLineMarkerProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/html/HtmlLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLineMarkerProvidersForLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllLineMarkerProvidersForLanguage";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

