/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchProjectViewPane
extends ProjectViewPane {
    public static final String ID = "Scratches";

    public static boolean isScratchesMergedIntoProjectTab() {
        return Registry.is((String)"ide.scratch.in.project.view") && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public ScratchProjectViewPane(final Project project) {
        super(project);
        ScratchProjectViewPane.registerUpdaters(project, this, new Runnable(){
            AbstractProjectViewPane updateTarget;

            @Override
            public void run() {
                if (this.updateTarget == null) {
                    AbstractProjectViewPane abstractProjectViewPane = this.updateTarget = !ScratchProjectViewPane.isScratchesMergedIntoProjectTab() ? ScratchProjectViewPane.this : ProjectView.getInstance(project).getProjectViewPaneById("ProjectPane");
                }
                if (this.updateTarget != null) {
                    this.updateTarget.updateFromRoot(true);
                }
            }
        });
    }

    @Override
    public String getTitle() {
        return ID;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Scope.Scratches;
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new MyTreeStructure(this.myProject);
    }

    @Override
    public int getWeight() {
        return 11;
    }

    @Override
    protected BaseProjectTreeBuilder createBuilder(DefaultTreeModel treeModel) {
        return null;
    }

    private static void registerUpdaters(@NotNull Project project, @NotNull Disposable disposable, final @NotNull Runnable onUpdate) {
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(2);
        }
        if (onUpdate == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(3);
        }
        project.getMessageBus().connect(disposable).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                boolean update;
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean bl = update = JBIterable.from(events).find(e -> ScratchUtil.isScratch(e.getFile())) != null;
                if (update) {
                    onUpdate.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/scratch/ScratchProjectViewPane$2", "after"));
            }
        });
        for (RootType rootId : RootType.getAllRootIds()) {
            if (rootId.isHidden()) continue;
            rootId.registerTreeUpdater(project, disposable, onUpdate);
        }
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            @Override
            protected boolean canSelect(PsiFileSystemItem file2) {
                VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
                if (vFile == null || !vFile.isValid()) {
                    return false;
                }
                if (!vFile.isInLocalFileSystem()) {
                    return false;
                }
                return ScratchFileService.getInstance().getRootType(vFile) != null;
            }

            @Override
            public String toString() {
                return ScratchProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return ScratchProjectViewPane.this.getId();
            }

            public float getWeight() {
                return ScratchProjectViewPane.this.getWeight();
            }
        };
    }

    @Nullable
    static PsiDirectory getDirectory(@NotNull Project project, @NotNull RootType rootId) {
        VirtualFile virtualFile;
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(4);
        }
        if (rootId == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(5);
        }
        return (virtualFile = ScratchProjectViewPane.getVirtualFile(rootId)) == null ? null : PsiManager.getInstance((Project)project).findDirectory(virtualFile);
    }

    @Nullable
    static VirtualFile getVirtualFile(@NotNull RootType rootId) {
        if (rootId == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(6);
        }
        String path = ScratchFileService.getInstance().getRootPath(rootId);
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Override
    public boolean isInitiallyVisible() {
        return !ScratchProjectViewPane.isScratchesMergedIntoProjectTab();
    }

    @NotNull
    public static AbstractTreeNode createRootNode(@NotNull Project project, @NotNull ViewSettings settings) {
        if (project == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(8);
        }
        MyProjectNode myProjectNode = new MyProjectNode(project, settings);
        if (myProjectNode == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(9);
        }
        return myProjectNode;
    }

    private static void customizePresentation(@NotNull BasePsiNode node, @NotNull PresentationData data) {
        Icon icon;
        MyRootNode rootNode;
        if (node == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(10);
        }
        if (data == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(11);
        }
        VirtualFile file2 = (VirtualFile)ObjectUtils.notNull((Object)node.getVirtualFile());
        Project project = (Project)ObjectUtils.notNull((Object)node.getProject());
        AbstractTreeNode parent = node.getParent();
        MyRootNode myRootNode = parent instanceof MyRootNode ? (MyRootNode)parent : (rootNode = parent instanceof PsiDirectoryNode ? (MyRootNode)((PsiDirectoryNode)parent).getFilter() : null);
        if (rootNode == null) {
            return;
        }
        RootType rootType = rootNode.getRootType();
        String name = rootType.substituteName(project, file2);
        if (name != null) {
            data.setPresentableText(name);
        }
        if ((icon = rootType.substituteIcon(project, file2)) != null) {
            data.setIcon(icon);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerUpdaters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRootNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRootNode
    extends ProjectViewNode<RootType>
    implements PsiFileSystemItemFilter {
        MyRootNode(Project project, RootType type, ViewSettings settings) {
            super(project, (Object)type, settings);
        }

        @NotNull
        public RootType getRootType() {
            RootType rootType = (RootType)ObjectUtils.notNull((Object)this.getValue());
            if (rootType == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            return rootType;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyRootNode.$$$reportNull$$$0(1);
            }
            return ScratchFileService.getInstance().getRootType(file2) == this.getValue();
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return ScratchProjectViewPane.getVirtualFile(this.getRootType());
        }

        @NotNull
        public Collection<VirtualFile> getRoots() {
            VirtualFile root = this.getVirtualFile();
            Set<VirtualFile> set2 = root == null ? EMPTY_ROOTS : Collections.singleton(root);
            if (set2 == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            return set2;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            Collection<AbstractTreeNode> collection = MyRootNode.getDirectoryChildrenImpl(this.getProject(), this.getDirectory(), this.getSettings(), this);
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(3);
            }
            return collection;
        }

        PsiDirectory getDirectory() {
            return ScratchProjectViewPane.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(AllIcons.Nodes.Folder);
            presentation.setPresentableText(this.getRootType().getDisplayName());
        }

        public boolean canRepresent(Object element) {
            return Comparing.equal((Object)this.getDirectory(), (Object)element);
        }

        public boolean isEmpty() {
            VirtualFile root = this.getVirtualFile();
            if (root == null) {
                return true;
            }
            RootType rootType = this.getRootType();
            Project project = (Project)ObjectUtils.notNull((Object)this.getProject());
            for (VirtualFile f : root.getChildren()) {
                if (rootType.isIgnored(project, f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldShow(@NotNull PsiFileSystemItem item) {
            if (item == null) {
                MyRootNode.$$$reportNull$$$0(4);
            }
            return !this.getRootType().isIgnored(this.getProject(), item.getVirtualFile());
        }

        @NotNull
        static Collection<AbstractTreeNode> getDirectoryChildrenImpl(final @NotNull Project project, @Nullable PsiDirectory directory2, final @NotNull ViewSettings settings, final @NotNull PsiFileSystemItemFilter filter) {
            if (project == null) {
                MyRootNode.$$$reportNull$$$0(5);
            }
            if (settings == null) {
                MyRootNode.$$$reportNull$$$0(6);
            }
            if (filter == null) {
                MyRootNode.$$$reportNull$$$0(7);
            }
            final ArrayList result2 = ContainerUtil.newArrayList();
            PsiElementProcessor<PsiFileSystemItem> processor2 = new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (filter.shouldShow(element)) {
                        if (element instanceof PsiDirectory) {
                            result2.add(new PsiDirectoryNode(project, (PsiDirectory)element, settings, filter){

                                @Override
                                public Collection<AbstractTreeNode> getChildrenImpl() {
                                    return MyRootNode.getDirectoryChildrenImpl(this.getProject(), (PsiDirectory)this.getValue(), this.getSettings(), this.getFilter());
                                }

                                @Override
                                protected void updateImpl(PresentationData data) {
                                    super.updateImpl(data);
                                    ScratchProjectViewPane.customizePresentation(this, data);
                                }
                            });
                        } else if (element instanceof PsiFile) {
                            result2.add(new PsiFileNode(project, (PsiFile)element, settings){

                                @Override
                                public Comparable getTypeSortKey() {
                                    PsiFile value = (PsiFile)this.getValue();
                                    Language language = value == null ? null : value.getLanguage();
                                    LanguageFileType fileType = language == null ? null : language.getAssociatedFileType();
                                    return fileType == null ? null : new PsiFileNode.ExtensionSortKey(fileType.getDefaultExtension());
                                }

                                @Override
                                protected void updateImpl(PresentationData data) {
                                    super.updateImpl(data);
                                    ScratchProjectViewPane.customizePresentation(this, data);
                                }
                            });
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode$1", "execute"));
                }
            };
            Collection collection = (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> MyRootNode.lambda$getDirectoryChildrenImpl$0(directory2, (PsiElementProcessor)processor2, result2));
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(8);
            }
            return collection;
        }

        private static /* synthetic */ List lambda$getDirectoryChildrenImpl$0(@Nullable PsiDirectory directory2, PsiElementProcessor processor2, List result2) {
            if (directory2 == null || !directory2.isValid()) {
                return Collections.emptyList();
            }
            directory2.processChildren(processor2);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootType";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldShow";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyProjectNode
    extends ProjectViewNode<String> {
        MyProjectNode(Project project, ViewSettings settings) {
            super(project, (Object)"Scratches and Consoles", settings);
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProjectNode.$$$reportNull$$$0(0);
            }
            return file2.getFileType() == ScratchFileType.INSTANCE;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList list2 = ContainerUtil.newArrayList();
            for (RootType rootId : RootType.getAllRootIds()) {
                MyRootNode e;
                if (rootId.isHidden() || (e = new MyRootNode(this.getProject(), rootId, this.getSettings())).isEmpty()) continue;
                list2.add(e);
            }
            ArrayList arrayList = list2;
            if (arrayList == null) {
                MyProjectNode.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        protected void update(PresentationData presentation) {
            presentation.setPresentableText((String)this.getValue());
            presentation.setIcon(AllIcons.Scope.Scratches);
        }

        public boolean canRepresent(Object element) {
            VirtualFile virtualFile;
            PsiElement item = element instanceof PsiElement ? (PsiElement)element : null;
            VirtualFile virtualFile2 = virtualFile = item == null ? null : PsiUtilCore.getVirtualFile((PsiElement)item);
            if (virtualFile == null) {
                return false;
            }
            return Comparing.equal((String)virtualFile.getPath(), (String)FileUtil.toSystemIndependentName((String)PathManager.getScratchPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTreeStructure
    extends ProjectTreeStructure {
        MyTreeStructure(Project project) {
            super(project, ScratchProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
            return ScratchProjectViewPane.createRootNode(project, settings);
        }

        @Override
        @Nullable
        public List<TreeStructureProvider> getProviders() {
            return null;
        }
    }

    public static class MyStructureProvider
    implements TreeStructureProvider,
    DumbAware {
        @NotNull
        public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
            Project project;
            if (parent == null) {
                MyStructureProvider.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                MyStructureProvider.$$$reportNull$$$0(1);
            }
            Project project2 = project = parent instanceof ProjectViewProjectNode ? parent.getProject() : null;
            if (project != null && ScratchProjectViewPane.isScratchesMergedIntoProjectTab()) {
                children2.add(ScratchProjectViewPane.createRootNode(project, settings));
            }
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                MyStructureProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @Nullable
        public Object getData(@NotNull Collection<AbstractTreeNode> selected, String dataName) {
            AbstractTreeNode single;
            if (selected == null) {
                MyStructureProvider.$$$reportNull$$$0(3);
            }
            if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataName) && (single = (AbstractTreeNode)JBIterable.from(selected).single()) instanceof MyRootNode) {
                VirtualFile file2 = ((MyRootNode)single).getVirtualFile();
                Project project = single.getProject();
                return file2 == null || project == null ? null : PsiManager.getInstance((Project)project).findDirectory(file2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyStructureProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyStructureProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "modify";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

