/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchUtil {
    private ScratchUtil() {
    }

    public static boolean isScratch(@Nullable VirtualFile file2) {
        RootType rootType = RootType.forFile((VirtualFile)file2);
        return rootType != null && !rootType.isHidden();
    }

    public static void updateFileExtension(@NotNull Project project, @Nullable VirtualFile file2) throws IOException {
        LanguageFileType currType;
        if (project == null) {
            ScratchUtil.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            throw new AssertionError((Object)"command required");
        }
        if (file2 == null) {
            return;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
        FileType prevType = ScratchUtil.getFileTypeFromName(file2);
        LanguageFileType languageFileType = currType = language == null ? null : language.getAssociatedFileType();
        if (prevType == currType) {
            return;
        }
        String prevExt = PathUtil.makeFileName((String)"", (String)(prevType == null ? "" : prevType.getDefaultExtension()));
        String currExt = currType == null ? "" : currType.getDefaultExtension();
        String nameWithoutExtension = prevExt.length() > 0 && file2.getName().endsWith(prevExt) ? StringUtil.trimEnd((String)file2.getName(), (String)prevExt) : file2.getNameWithoutExtension();
        VirtualFile parent = file2.getParent();
        String newName = parent != null ? VfsUtil.getNextAvailableName((VirtualFile)parent, (String)nameWithoutExtension, (String)currExt) : PathUtil.makeFileName((String)nameWithoutExtension, (String)currExt);
        file2.rename(ScratchUtil.class, newName);
    }

    public static boolean hasMatchingExtension(@NotNull Project project, @NotNull VirtualFile file2) {
        LanguageFileType actual;
        if (project == null) {
            ScratchUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ScratchUtil.$$$reportNull$$$0(2);
        }
        if (file2.getExtension() == null) {
            return true;
        }
        FileType expected = ScratchUtil.getFileTypeFromName(file2);
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
        LanguageFileType languageFileType = actual = language == null ? null : language.getAssociatedFileType();
        if (expected != null && expected == actual) {
            return true;
        }
        String ext = actual == null ? "" : actual.getDefaultExtension();
        return ext.length() > 0 && file2.getName().endsWith(ext);
    }

    @Nullable
    private static FileType getFileTypeFromName(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ScratchUtil.$$$reportNull$$$0(3);
        }
        if (file2.getExtension() == null) {
            return null;
        }
        FileType result2 = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
        if (result2 == UnknownFileType.INSTANCE || StringUtil.isEmpty((String)result2.getDefaultExtension())) {
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/scratch/ScratchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFileExtension";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMatchingExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileTypeFromName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

