/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class DarculaTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTextFieldUI();
    }

    @Override
    protected int getMinimumHeight(int textHeight) {
        Insets i = this.getComponent().getInsets();
        JTextComponent c = this.getComponent();
        int minHeight = (DarculaUIUtil.isCompact(c) ? DarculaUIUtil.COMPACT_HEIGHT.get() : DarculaUIUtil.MINIMUM_HEIGHT.get()) + i.top + i.bottom;
        return DarculaEditorTextFieldBorder.isComboBoxEditor(c) || UIUtil.getParentOfType(JSpinner.class, (Component)c) != null ? textHeight : minHeight;
    }

    @Override
    protected Icon getSearchIcon(boolean hovered, boolean clickable) {
        return LafIconLookup.getIcon((String)(clickable ? "searchWithHistory" : "search"));
    }

    @Override
    protected Icon getClearIcon(boolean hovered, boolean clickable) {
        return !clickable ? null : LafIconLookup.getIcon((String)"clear");
    }

    @Override
    protected int getClearIconPreferredSpace() {
        return super.getClearIconPreferredSpace() - this.getClearIconGap();
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent component = this.getComponent();
        if (component != null) {
            Container parent = component.getParent();
            if (parent != null && component.isOpaque()) {
                g.setColor(parent.getBackground());
                g.fillRect(0, 0, component.getWidth(), component.getHeight());
            }
            if (component.getBorder() instanceof DarculaTextBorder) {
                this.paintDarculaBackground(g, component);
            } else if (component.isOpaque()) {
                super.paintBackground(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintDarculaBackground(Graphics g, JTextComponent component) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(component.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)DarculaUIUtil.paddings());
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            if (component.isEnabled() && component.isEditable()) {
                float arc = DarculaTextFieldUI.isSearchField(component) ? DarculaUIUtil.COMPONENT_ARC.getFloat() : 0.0f;
                float bw = this.bw();
                g2.setColor(component.getBackground());
                g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected Insets getDefaultMargins() {
        return DarculaUIUtil.isCompact(this.getComponent()) ? JBUI.insets((int)0, (int)5) : JBUI.insets((int)2, (int)5);
    }

    protected float bw() {
        return DarculaUIUtil.BW.getFloat();
    }
}

