/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EventLogExternalSettingsService
extends SettingsConnectionService
implements EventLogSettingsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService");
    private static final String APPROVED_GROUPS_SERVICE = "white-list-service";
    private static final String PERCENT_TRAFFIC = "percent-traffic";

    public static EventLogExternalSettingsService getInstance() {
        return new EventLogExternalSettingsService();
    }

    protected EventLogExternalSettingsService() {
        super(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEventLogSettingsUrl(), null);
    }

    @NotNull
    public String[] getAttributeNames() {
        String[] stringArray = ArrayUtil.mergeArrays((String[])super.getAttributeNames(), (String[])new String[]{PERCENT_TRAFFIC, APPROVED_GROUPS_SERVICE});
        if (stringArray == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @Override
    public int getPermittedTraffic() {
        String permitted = this.getSettingValue(PERCENT_TRAFFIC);
        if (permitted != null) {
            try {
                return Integer.parseInt(permitted);
            }
            catch (NumberFormatException e) {
                LOG.trace("Permitted traffic is not defined or has invalid format: '" + permitted + "'");
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public LogEventFilter getEventFilter() {
        Set<String> whitelist = this.getWhitelistedGroups();
        LogEventWhitelistFilter logEventWhitelistFilter = new LogEventWhitelistFilter(whitelist);
        if (logEventWhitelistFilter == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(1);
        }
        return logEventWhitelistFilter;
    }

    @NotNull
    private Set<String> getWhitelistedGroups() {
        String approvedGroupsServiceUrl = this.getSettingValue(APPROVED_GROUPS_SERVICE);
        if (approvedGroupsServiceUrl == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                EventLogExternalSettingsService.$$$reportNull$$$0(2);
            }
            return set2;
        }
        String productUrl = approvedGroupsServiceUrl + ApplicationInfo.getInstance().getBuild().getProductCode() + ".json";
        Set<String> set3 = FUStatisticsWhiteListGroupsService.getApprovedGroups(productUrl);
        if (set3 == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(3);
        }
        return set3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/eventLog/EventLogExternalSettingsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitelistedGroups";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

