/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.gson.JsonSyntaxException;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordSizeEstimator;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "", "product", "", "user", "records", "", "Lcom/intellij/internal/statistic/eventLog/LogEventRecord;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getProduct", "()Ljava/lang/String;", "getRecords", "()Ljava/util/List;", "getUser", "equals", "", "other", "hashCode", "", "Companion", "intellij.platform.ide.impl"})
public final class LogEventRecordRequest {
    @NotNull
    private final String product;
    @NotNull
    private final String user;
    @NotNull
    private final List<LogEventRecord> records;
    private static final int RECORD_SIZE = 1000000;
    private static final Logger LOG;
    public static final Companion Companion;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.LogEventRecordRequest");
        }
        LogEventRecordRequest cfr_ignored_0 = (LogEventRecordRequest)object2;
        if (Intrinsics.areEqual((Object)this.product, (Object)((LogEventRecordRequest)other).product) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.user, (Object)((LogEventRecordRequest)other).user) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.records, ((LogEventRecordRequest)other).records) ^ true);
    }

    public int hashCode() {
        int result2 = this.product.hashCode();
        result2 = 31 * result2 + this.user.hashCode();
        result2 = 31 * result2 + ((Object)this.records).hashCode();
        return result2;
    }

    @NotNull
    public final String getProduct() {
        return this.product;
    }

    @NotNull
    public final String getUser() {
        return this.user;
    }

    @NotNull
    public final List<LogEventRecord> getRecords() {
        return this.records;
    }

    public LogEventRecordRequest(@NotNull String product, @NotNull String user, @NotNull List<LogEventRecord> records) {
        Intrinsics.checkParameterIsNotNull((Object)product, (String)"product");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull(records, (String)"records");
        this.product = product;
        this.user = user;
        this.records = records;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LogEventRecordRequest.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(LogEv\u2026ecordRequest::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ0\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJB\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RECORD_SIZE", "", "create", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "file", "Ljava/io/File;", "filter", "Lcom/intellij/internal/statistic/eventLog/LogEventFilter;", "product", "", "user", "maxRecordSize", "fillNextBatch", "reader", "Ljava/io/BufferedReader;", "firstLine", "events", "", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "estimator", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordSizeEstimator;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @Nullable
        public final LogEventRecordRequest create(@NotNull File file2, @NotNull LogEventFilter filter) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
            try {
                ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                BuildNumber buildNumber = applicationInfo.getBuild();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
                String string = buildNumber.getProductCode();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationInfo.getInstance().build.productCode");
                String string2 = PermanentInstallationID.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PermanentInstallationID.get()");
                return this.create(file2, string, string2, 1000000, filter);
            }
            catch (Exception e) {
                LOG.warn("Failed reading event log file", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final LogEventRecordRequest create(@NotNull File file2, @NotNull String product, @NotNull String user, int maxRecordSize, @NotNull LogEventFilter filter) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)product, (String)"product");
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
            try {
                ArrayList<LogEventRecord> records = new ArrayList<LogEventRecord>();
                Closeable closeable = new BufferedReader(new FileReader(file2.getPath()));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    LogEventRecordSizeEstimator sizeEstimator = new LogEventRecordSizeEstimator(product, user);
                    ArrayList events = new ArrayList();
                    String line = Companion.fillNextBatch(reader, reader.readLine(), events, sizeEstimator, maxRecordSize, filter);
                    while (!events.isEmpty()) {
                        records.add(new LogEventRecord(events));
                        events = new ArrayList();
                        line = Companion.fillNextBatch(reader, line, events, sizeEstimator, maxRecordSize, filter);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return new LogEventRecordRequest(product, user, (List<LogEventRecord>)records);
            }
            catch (JsonSyntaxException e) {
                LOG.warn((Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            return null;
        }

        private final String fillNextBatch(BufferedReader reader, String firstLine, List<LogEvent> events, LogEventRecordSizeEstimator estimator, int maxRecordSize, LogEventFilter filter) {
            int recordSize = 0;
            String line = firstLine;
            while (line != null && recordSize + estimator.estimate(line) < maxRecordSize) {
                LogEvent event = LogEventSerializer.INSTANCE.fromString(line);
                if (event != null && filter.accepts(event.getGroup().getId())) {
                    recordSize += estimator.estimate(line);
                    events.add(event);
                }
                line = reader.readLine();
            }
            return line;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

