/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.FUStatisticsSettingsService;
import com.intellij.internal.statistic.service.fus.beans.FSContent;
import com.intellij.internal.statistic.service.fus.beans.FSSession;
import com.intellij.internal.statistic.service.fus.collectors.FUSession;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsAggregator;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsPersistence {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence");
    private static final String FILE_EXTENSION = "json";
    private static final String PERSISTENCE_STATE_FILE = "fus-previous-state.data";
    private static final String SENT_DATA_FILE = "fus-sent-data.json";
    public static final String FUS_CACHE_PATH = "fus-sessions";

    public static String persistProjectUsages(@NotNull Project project) {
        Set<String> groups;
        if (project == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(0);
        }
        if ((groups = FUStatisticsSettingsService.getInstance().getApprovedGroups()).isEmpty() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
            return null;
        }
        FUStatisticsAggregator aggregator = FUStatisticsAggregator.create();
        Map<String, Set<UsageDescriptor>> usages = aggregator.getProjectUsages(project, groups);
        if (usages.isEmpty()) {
            return null;
        }
        FUSession fuSession = FUSession.create(project);
        FSContent content = FSContent.create();
        FUStatisticsAggregator.writeContent(content, fuSession, usages);
        String gsonContent = content.asJsonString();
        String fileName = FUStatisticsPersistence.getFileName(fuSession);
        File directory2 = FUStatisticsPersistence.getStatisticsSystemCacheDirectory();
        FUStatisticsPersistence.persistToFile(gsonContent, new File(directory2, "/" + fileName));
        return fileName;
    }

    @NotNull
    public static Set<FSSession> getPersistedSessions() {
        File[] children2;
        HashSet persistedSessions = ContainerUtil.newHashSet();
        File statisticsCacheDir = FUStatisticsPersistence.getStatisticsSystemCacheDirectory();
        if (statisticsCacheDir != null && (children2 = statisticsCacheDir.listFiles()) != null) {
            for (File child : children2) {
                if (PERSISTENCE_STATE_FILE.equals(child.getName()) || SENT_DATA_FILE.equals(child.getName()) || !FUStatisticsPersistence.isSessionCacheName(child.getName())) continue;
                try {
                    FUStatisticsPersistence.mergeContent(persistedSessions, FileUtil.loadFile((File)child));
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        HashSet hashSet = persistedSessions;
        if (hashSet == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static void clearSessionPersistence(long dataTime) {
        File[] children2;
        File statisticsCacheDir = FUStatisticsPersistence.getStatisticsSystemCacheDirectory();
        if (statisticsCacheDir != null && (children2 = statisticsCacheDir.listFiles()) != null) {
            for (File child : children2) {
                if (PERSISTENCE_STATE_FILE.equals(child.getName()) || SENT_DATA_FILE.equals(child.getName())) continue;
                try {
                    BasicFileAttributes attr = Files.readAttributes(child.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (dataTime <= attr.creationTime().toMillis()) continue;
                    child.delete();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    @NotNull
    private static String getFileName(@NotNull FUSession session2) {
        if (session2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(2);
        }
        String string = session2.hashCode() + "." + FILE_EXTENSION;
        if (string == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static File getStatisticsSystemCacheDirectory() {
        return Paths.get(PathManager.getSystemPath(), new String[0]).resolve(FUS_CACHE_PATH).toFile();
    }

    private static void mergeContent(@NotNull Set<FSSession> allSessions, @Nullable String content) {
        if (allSessions == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)content)) {
            return;
        }
        try {
            FSContent sessionContent = FSContent.fromJson(content);
            if (sessionContent == null) {
                return;
            }
            Set<FSSession> sessions = sessionContent.getSessions();
            if (sessions != null) {
                allSessions.addAll(sessions);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    public static void persistDataFromCollectors(@NotNull String content) {
        if (content == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(5);
        }
        FUStatisticsPersistence.persistToFile(content, FUStatisticsPersistence.getPersistenceStateFile());
    }

    public static void persistSentData(@NotNull String sentContent) {
        if (sentContent == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(6);
        }
        FUStatisticsPersistence.persistToFile(sentContent, FUStatisticsPersistence.getSentDataFile());
    }

    public static void persistToFile(@NotNull String sentContent, File file2) {
        if (sentContent == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(7);
        }
        try {
            FileUtil.writeToFile((File)file2, (String)sentContent);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public static File getPersistenceStateFile() {
        File file2 = new File(FUStatisticsPersistence.getStatisticsSystemCacheDirectory(), "/fus-previous-state.data");
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(8);
        }
        return file2;
    }

    @NotNull
    public static File getSentDataFile() {
        File file2 = new File(FUStatisticsPersistence.getStatisticsSystemCacheDirectory(), "/fus-sent-data.json");
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(9);
        }
        return file2;
    }

    @Nullable
    public static String getPreviousStateContent() {
        File stateFile;
        File statisticsCacheDir = FUStatisticsPersistence.getStatisticsSystemCacheDirectory();
        if (statisticsCacheDir != null && (stateFile = FUStatisticsPersistence.getPersistenceStateFile()).exists()) {
            try {
                return FileUtil.loadFile((File)stateFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    private static boolean isSessionCacheName(@NotNull String fileName) {
        if (fileName == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(10);
        }
        return FILE_EXTENSION.equals(FileUtilRt.getExtension((String)fileName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsPersistence";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSessions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sentContent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsPersistence";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistedSessions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceStateFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSentDataFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "persistProjectUsages";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mergeContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "persistDataFromCollectors";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "persistSentData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "persistToFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSessionCacheName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

