/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.lang.customFolding.CustomFoldingRegionsPopup;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoCustomRegionAction
extends AnAction
implements DumbAware,
PopupAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (Boolean.TRUE.equals(e.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            return;
        }
        if (project != null && editor != null) {
            if (DumbService.getInstance((Project)project).isDumb()) {
                DumbService.getInstance((Project)project).showDumbModeNotification(IdeBundle.message((String)"goto.custom.region.message.dumb.mode", (Object[])new Object[0]));
                return;
            }
            CommandProcessor processor2 = CommandProcessor.getInstance();
            processor2.executeCommand(project, () -> {
                Collection<FoldingDescriptor> foldingDescriptors = GotoCustomRegionAction.getCustomFoldingDescriptors(editor, project);
                if (foldingDescriptors.size() > 0) {
                    CustomFoldingRegionsPopup.show(foldingDescriptors, editor, project);
                } else {
                    GotoCustomRegionAction.notifyCustomRegionsUnavailable(editor, project);
                }
            }, IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0]), null);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setText(IdeBundle.message((String)"goto.custom.region.menu.item", (Object[])new Object[0]));
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        boolean isAvailable = editor != null && project != null;
        presentation.setEnabled(isAvailable);
        presentation.setVisible(isAvailable);
    }

    @NotNull
    private static Collection<FoldingDescriptor> getCustomFoldingDescriptors(@NotNull Editor editor, @NotNull Project project) {
        PsiFile file2;
        if (editor == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(1);
        }
        HashSet<FoldingDescriptor> foldingDescriptors = new HashSet<FoldingDescriptor>();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = file2 = documentManager != null ? documentManager.getPsiFile(document) : null;
        if (file2 != null) {
            FileViewProvider viewProvider = file2.getViewProvider();
            for (Language language : viewProvider.getLanguages()) {
                PsiFile psi = viewProvider.getPsi(language);
                FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
                if (psi == null) continue;
                for (FoldingDescriptor descriptor2 : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)false)) {
                    CustomFoldingBuilder customFoldingBuilder = GotoCustomRegionAction.getCustomFoldingBuilder(foldingBuilder, descriptor2);
                    if (customFoldingBuilder == null || !customFoldingBuilder.isCustomRegionStart(descriptor2.getElement())) continue;
                    foldingDescriptors.add(descriptor2);
                }
            }
        }
        HashSet<FoldingDescriptor> hashSet = foldingDescriptors;
        if (hashSet == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @Nullable
    private static CustomFoldingBuilder getCustomFoldingBuilder(FoldingBuilder builder2, FoldingDescriptor descriptor2) {
        if (builder2 instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)builder2;
        }
        FoldingBuilder originalBuilder = (FoldingBuilder)descriptor2.getElement().getUserData(CompositeFoldingBuilder.FOLDING_BUILDER);
        if (originalBuilder instanceof CustomFoldingBuilder) {
            return (CustomFoldingBuilder)originalBuilder;
        }
        return null;
    }

    private static void notifyCustomRegionsUnavailable(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GotoCustomRegionAction.$$$reportNull$$$0(4);
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        Balloon balloon = popupFactory.createHtmlTextBalloonBuilder(IdeBundle.message((String)"goto.custom.region.message.unavailable", (Object[])new Object[0]), MessageType.INFO, null).setFadeoutTime(2000L).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon();
        Disposer.register((Disposable)project, (Disposable)balloon);
        balloon.show(popupFactory.guessBestPopupLocation(editor), Balloon.Position.below);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/customFolding/GotoCustomRegionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/customFolding/GotoCustomRegionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFoldingDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomFoldingDescriptors";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyCustomRegionsUnavailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

