/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanelColumn;
import com.intellij.openapi.diff.impl.splitter.DividerPolygon;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorPlace
extends JComponent
implements Disposable,
ButtonlessScrollBarUI.ScrollbarRepaintCallback {
    private static final Logger LOG = Logger.getInstance(EditorPlace.class);
    @NotNull
    private final MergePanel2.DiffEditorState myState;
    @NotNull
    private final MergePanelColumn myColumn;
    @NotNull
    private final MergePanel2 myMergePanel;
    @NotNull
    private final List<EditorListener> myListeners;
    @Nullable
    private EditorEx myEditor;

    public EditorPlace(@NotNull MergePanel2.DiffEditorState state2, @NotNull MergePanelColumn column, @NotNull MergePanel2 mergePanel) {
        if (state2 == null) {
            EditorPlace.$$$reportNull$$$0(0);
        }
        if (column == null) {
            EditorPlace.$$$reportNull$$$0(1);
        }
        if (mergePanel == null) {
            EditorPlace.$$$reportNull$$$0(2);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myState = state2;
        this.myColumn = column;
        this.myMergePanel = mergePanel;
        this.setLayout(new BorderLayout());
    }

    public void call(Graphics g) {
        this.paintThis(g);
    }

    private void paintThis(Graphics g) {
        if (this.myEditor == null) {
            return;
        }
        if (this.myColumn != MergePanelColumn.BASE) {
            return;
        }
        int offset = 2;
        ArrayList<DividerPolygon> polygons = DividerPolygon.createVisiblePolygons(this.myMergePanel.getSecondEditingSide(), FragmentSide.SIDE1, offset);
        for (DividerPolygon polygon : polygons) {
            int startY = polygon.getTopLeftY();
            int endY = polygon.getBottomLeftY();
            int height = endY - startY;
            if (height == 0) {
                height = 1;
            }
            this.drawPolygon((Graphics2D)g, startY, height, polygon.getColor(), polygon.isApplied());
        }
    }

    private void drawPolygon(@NotNull Graphics2D g, int startY, int height, @NotNull Color color, boolean applied) {
        if (g == null) {
            EditorPlace.$$$reportNull$$$0(3);
        }
        if (color == null) {
            EditorPlace.$$$reportNull$$$0(4);
        }
        int scrollbarWidth = this.myEditor.getScrollPane().getVerticalScrollBar().getWidth();
        int startX = 0;
        int endX = startX + scrollbarWidth - 1;
        int endY = startY + height;
        g.setColor(color);
        if (!applied) {
            if (height > 2) {
                g.fillRect(startX, startY, scrollbarWidth, height);
                Color framingColor = DiffUtil.getFramingColor(color);
                UIUtil.drawLine((Graphics2D)g, (int)startX, (int)startY, (int)endX, (int)startY, null, (Color)framingColor);
                UIUtil.drawLine((Graphics2D)g, (int)startX, (int)endY, (int)endX, (int)endY, null, (Color)framingColor);
            } else {
                DiffUtil.drawDoubleShadowedLine(g, startX, endX, startY, color);
            }
        } else {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)startY, null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)endY, null, (Color)color, (boolean)false);
        }
    }

    @Override
    public void addNotify() {
        if (this.myEditor != null) {
            super.addNotify();
            return;
        }
        this.createEditor();
        super.addNotify();
        this.revalidate();
    }

    private void createEditor() {
        LOG.assertTrue(this.myEditor == null);
        this.myEditor = this.myState.createEditor();
        if (this.myEditor == null) {
            return;
        }
        this.add((Component)this.myEditor.getComponent(), "Center");
        this.myEditor.registerScrollBarRepaintCallback(this);
        this.repaint();
        this.fireEditorCreated();
    }

    public void addListener(EditorListener listener2) {
        this.myListeners.add(listener2);
    }

    private void fireEditorCreated() {
        for (EditorListener listener2 : this.myListeners) {
            listener2.onEditorCreated(this);
        }
    }

    private void fireEditorReleased(Editor releasedEditor) {
        for (EditorListener listener2 : this.myListeners) {
            listener2.onEditorReleased(releasedEditor);
        }
    }

    @Override
    public void removeNotify() {
        this.removeEditor();
        super.removeNotify();
    }

    private void removeEditor() {
        if (this.myEditor != null) {
            this.myEditor.registerScrollBarRepaintCallback(null);
            EditorEx releasedEditor = this.myEditor;
            this.remove(this.myEditor.getComponent());
            EditorPlace.getEditorFactory().releaseEditor((Editor)this.myEditor);
            this.myEditor = null;
            this.fireEditorReleased(releasedEditor);
        }
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public void setDocument(@Nullable Document document) {
        if (document == this.getDocument()) {
            return;
        }
        this.removeEditor();
        this.myState.setDocument(document);
        this.createEditor();
    }

    private Document getDocument() {
        return this.myState.getDocument();
    }

    @NotNull
    public MergePanel2.DiffEditorState getState() {
        MergePanel2.DiffEditorState diffEditorState = this.myState;
        if (diffEditorState == null) {
            EditorPlace.$$$reportNull$$$0(5);
        }
        return diffEditorState;
    }

    private static EditorFactory getEditorFactory() {
        return EditorFactory.getInstance();
    }

    @Nullable
    public JComponent getContentComponent() {
        return this.myEditor == null ? null : this.myEditor.getContentComponent();
    }

    public void dispose() {
        this.removeEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/ui/EditorPlace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawPolygon";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface EditorListener {
        public void onEditorCreated(EditorPlace var1);

        public void onEditorReleased(Editor var1);
    }
}

