/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorLastActionTracker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.LightweightHint;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class SelectOccurrencesActionHandler
extends EditorActionHandler {
    private static final Key<Boolean> NOT_FOUND = Key.create((String)"select.next.occurence.not.found");
    private static final Key<Boolean> WHOLE_WORDS = Key.create((String)"select.next.occurence.whole.words");
    private static final Set<String> SELECT_ACTIONS = new HashSet<String>(Arrays.asList("SelectNextOccurrence", "UnselectPreviousOccurrence", "FindNext", "FindPrevious"));

    protected static void setSelection(Editor editor, Caret caret, TextRange selectionRange) {
        EditorActionUtil.makePositionVisible(editor, selectionRange.getStartOffset());
        EditorActionUtil.makePositionVisible(editor, selectionRange.getEndOffset());
        caret.setSelection(selectionRange.getStartOffset(), selectionRange.getEndOffset());
    }

    protected static void showHint(Editor editor) {
        String message = FindBundle.message("select.next.occurence.not.found.message", new Object[0]);
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(message));
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 40, 0, false);
    }

    protected static boolean getAndResetNotFoundStatus(Editor editor) {
        boolean status = editor.getUserData(NOT_FOUND) != null;
        editor.putUserData(NOT_FOUND, null);
        return status && SelectOccurrencesActionHandler.isRepeatedActionInvocation();
    }

    protected static void setNotFoundStatus(Editor editor) {
        editor.putUserData(NOT_FOUND, (Object)Boolean.TRUE);
    }

    protected static boolean isWholeWordSearch(Editor editor) {
        Boolean value;
        if (!SelectOccurrencesActionHandler.isRepeatedActionInvocation()) {
            editor.putUserData(WHOLE_WORDS, null);
        }
        return (value = (Boolean)editor.getUserData(WHOLE_WORDS)) != null;
    }

    @Nullable
    protected static TextRange getSelectionRange(Editor editor, Caret caret) {
        return SelectWordUtil.getWordSelectionRange(editor.getDocument().getCharsSequence(), caret.getOffset(), SelectWordUtil.JAVA_IDENTIFIER_PART_CONDITION);
    }

    protected static void setWholeWordSearch(Editor editor, boolean isWholeWordSearch) {
        editor.putUserData(WHOLE_WORDS, (Object)isWholeWordSearch);
    }

    protected static boolean isRepeatedActionInvocation() {
        String lastActionId = EditorLastActionTracker.getInstance().getLastActionId();
        return SELECT_ACTIONS.contains(lastActionId);
    }

    protected static FindModel getFindModel(String text2, boolean wholeWords) {
        FindModel model = new FindModel();
        model.setStringToFind(text2);
        model.setCaseSensitive(true);
        model.setWholeWordsOnly(wholeWords);
        return model;
    }
}

