/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.util.registry.Registry;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyntaxAwareReaderTransferableData
extends Reader
implements RawTextWithMarkup {
    private static final Logger LOG = Logger.getInstance(AbstractSyntaxAwareReaderTransferableData.class);
    protected String myRawText;
    @NotNull
    protected final SyntaxInfo mySyntaxInfo;
    @NotNull
    private final DataFlavor myDataFlavor;
    @Nullable
    private transient Reader myDelegate;

    public AbstractSyntaxAwareReaderTransferableData(@NotNull SyntaxInfo syntaxInfo, @NotNull DataFlavor dataFlavor) {
        if (syntaxInfo == null) {
            AbstractSyntaxAwareReaderTransferableData.$$$reportNull$$$0(0);
        }
        if (dataFlavor == null) {
            AbstractSyntaxAwareReaderTransferableData.$$$reportNull$$$0(1);
        }
        this.mySyntaxInfo = syntaxInfo;
        this.myDataFlavor = dataFlavor;
    }

    @Override
    public DataFlavor getFlavor() {
        return this.myDataFlavor;
    }

    @Override
    public int getOffsetCount() {
        return 0;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        return index;
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        return index;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            AbstractSyntaxAwareReaderTransferableData.$$$reportNull$$$0(2);
        }
        return this.getDelegate().read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myDelegate = null;
    }

    @Override
    public void setRawText(String rawText) {
        this.myRawText = rawText;
    }

    @NotNull
    private Reader getDelegate() {
        if (this.myDelegate != null) {
            Reader reader = this.myDelegate;
            if (reader == null) {
                AbstractSyntaxAwareReaderTransferableData.$$$reportNull$$$0(3);
            }
            return reader;
        }
        int maxLength = Registry.intValue((String)"editor.richcopy.max.size.megabytes") * 0x100000;
        StringBuilder buffer = new StringBuilder();
        try {
            this.build(buffer, maxLength);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        String s = buffer.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting text: \n" + s);
        }
        Reader reader = this.myDelegate = new StringReader(s);
        if (reader == null) {
            AbstractSyntaxAwareReaderTransferableData.$$$reportNull$$$0(4);
        }
        return reader;
    }

    protected abstract void build(@NotNull StringBuilder var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlavor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cbuf";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReaderTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReaderTransferableData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

