/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.Navigatable;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRemoteFileEditor
implements TextEditor,
PropertyChangeListener {
    private Editor myMockTextEditor;
    private Navigatable myPendingNavigatable;
    protected final Project myProject;
    private final UserDataHolderBase myUserDataHolder;
    private final EventDispatcher<PropertyChangeListener> myDispatcher;

    protected BaseRemoteFileEditor(@NotNull Project project) {
        if (project == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(0);
        }
        this.myUserDataHolder = new UserDataHolderBase();
        this.myDispatcher = EventDispatcher.create(PropertyChangeListener.class);
        this.myProject = project;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        TextEditor textEditor = this.getTextEditor();
        return textEditor == null ? null : textEditor.getStructureViewBuilder();
    }

    @NotNull
    public Editor getEditor() {
        TextEditor fileEditor = this.getTextEditor();
        if (fileEditor != null) {
            Editor editor = fileEditor.getEditor();
            if (editor == null) {
                BaseRemoteFileEditor.$$$reportNull$$$0(1);
            }
            return editor;
        }
        if (this.myMockTextEditor == null) {
            this.myMockTextEditor = EditorFactory.getInstance().createViewer((Document)new DocumentImpl(""), this.myProject);
        }
        Editor editor = this.myMockTextEditor;
        if (editor == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(2);
        }
        return editor;
    }

    @Nullable
    protected abstract TextEditor getTextEditor();

    public FileEditorLocation getCurrentLocation() {
        TextEditor textEditor = this.getTextEditor();
        return textEditor == null ? null : textEditor.getCurrentLocation();
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        TextEditor textEditor = this.getTextEditor();
        return textEditor == null ? null : textEditor.getBackgroundHighlighter();
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        TextEditor textEditor;
        if (level == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(3);
        }
        TextEditorState textEditorState = (textEditor = this.getTextEditor()) == null ? new TextEditorState() : textEditor.getState(level);
        if (textEditorState == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(4);
        }
        return textEditorState;
    }

    public void setState(@NotNull FileEditorState state2) {
        TextEditor textEditor;
        if (state2 == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(5);
        }
        if ((textEditor = this.getTextEditor()) != null && state2 instanceof TextEditorState) {
            textEditor.setState(state2);
        }
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        TextEditor textEditor;
        if (key == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(6);
        }
        return (T)((textEditor = this.getTextEditor()) == null ? this.myUserDataHolder.getUserData(key) : textEditor.getUserData(key));
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        TextEditor textEditor;
        if (key == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(7);
        }
        if ((textEditor = this.getTextEditor()) == null) {
            this.myUserDataHolder.putUserData(key, value);
        } else {
            textEditor.putUserData(key, value);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        TextEditor editor = this.getTextEditor();
        return editor == null || editor.isValid();
    }

    public void dispose() {
        if (this.myMockTextEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myMockTextEditor);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(8);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(9);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(10);
        }
        ((PropertyChangeListener)this.myDispatcher.getMulticaster()).propertyChange(event);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        TextEditor editor;
        if (navigatable == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(11);
        }
        return (editor = this.getTextEditor()) == null ? this.isValid() : editor.canNavigateTo(navigatable);
    }

    public final void navigateTo(@NotNull Navigatable navigatable) {
        TextEditor editor;
        if (navigatable == null) {
            BaseRemoteFileEditor.$$$reportNull$$$0(12);
        }
        if ((editor = this.getTextEditor()) != null) {
            editor.navigateTo(navigatable);
        } else if (this.isValid()) {
            this.myPendingNavigatable = navigatable;
        }
    }

    protected final void contentLoaded() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Navigatable navigatable = this.myPendingNavigatable;
        if (navigatable != null) {
            this.myPendingNavigatable = null;
            TextEditor editor = this.getTextEditor();
            assert (editor != null);
            editor.navigateTo(navigatable);
        }
        if (this.myMockTextEditor != null) {
            if (!this.myMockTextEditor.isDisposed()) {
                EditorFactory.getInstance().releaseEditor(this.myMockTextEditor);
            }
            this.myMockTextEditor = null;
        }
    }

    protected final void contentRejected() {
        this.myPendingNavigatable = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

