/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class MoveEditorToOppositeTabGroupAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent event) {
        EditorWindow[] siblings;
        DataContext dataContext = event.getDataContext();
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (vFile == null || project == null) {
            return;
        }
        EditorWindow window = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        if (window != null && (siblings = window.findSiblings()) != null && siblings.length == 1) {
            EditorWithProviderComposite editorComposite = window.getSelectedEditor();
            HistoryEntry entry = editorComposite.currentStateAsHistoryEntry();
            vFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)Boolean.TRUE);
            this.closeOldFile(vFile, window);
            ((FileEditorManagerImpl)FileEditorManagerEx.getInstanceEx(project)).openFileImpl3(siblings[0], vFile, true, entry, true);
            vFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
        }
    }

    protected void closeOldFile(VirtualFile vFile, EditorWindow window) {
        window.closeFile(vFile, true, false);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        EditorWindow window = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(MoveEditorToOppositeTabGroupAction.isEnabled(vFile, window));
        } else {
            presentation.setEnabled(MoveEditorToOppositeTabGroupAction.isEnabled(vFile, window));
        }
    }

    private static boolean isEnabled(VirtualFile vFile, EditorWindow window) {
        EditorWindow[] siblings;
        return vFile != null && window != null && (siblings = window.findSiblings()) != null && siblings.length == 1;
    }
}

