/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.service.fus.collectors.FUSApplicationUsageTrigger;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class UpdateCheckerComponent
implements Disposable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(UpdateCheckerComponent.class);
    private static final long CHECK_INTERVAL = 86400000L;
    static final String SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY = "ide.self.update.started.for.build";
    private final Alarm myCheckForUpdatesAlarm;
    private final Runnable myCheckRunnable;
    private final UpdateSettings mySettings;

    public UpdateCheckerComponent(@NotNull Application app, @NotNull UpdateSettings settings) {
        if (app == null) {
            UpdateCheckerComponent.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            UpdateCheckerComponent.$$$reportNull$$$0(1);
        }
        this.myCheckForUpdatesAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myCheckRunnable = () -> UpdateChecker.updateAndShowResult().doWhenProcessed(() -> this.queueNextCheck(86400000L));
        Disposer.register((Disposable)this, (Disposable)this.myCheckForUpdatesAlarm);
        this.mySettings = settings;
        this.updateDefaultChannel();
        this.checkSecureConnection();
        this.scheduleOnStartCheck(app);
        UpdateCheckerComponent.cleanupPatch();
        this.snapPackageNotification(app);
    }

    private void updateDefaultChannel() {
        ChannelStatus current = this.mySettings.getSelectedChannelStatus();
        LOG.info("channel: " + current.getCode());
        boolean eap = ApplicationInfoEx.getInstanceEx().isEAP();
        if (eap && current != ChannelStatus.EAP && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
            this.mySettings.setSelectedChannelStatus(ChannelStatus.EAP);
            LOG.info("channel forced to 'eap'");
            if (!ConfigImportHelper.isFirstSession()) {
                String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
                String message = IdeBundle.message((String)"update.channel.enforced", (Object[])new Object[]{ChannelStatus.EAP});
                UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.INFORMATION, null).notify(null);
            }
        }
        if (!eap && current == ChannelStatus.EAP && ConfigImportHelper.isConfigImported()) {
            this.mySettings.setSelectedChannelStatus(ChannelStatus.RELEASE);
            LOG.info("channel set to 'release'");
        }
    }

    private void checkSecureConnection() {
        if (this.mySettings.isSecureConnection() && !this.mySettings.canUseSecureConnection()) {
            String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
            String message = IdeBundle.message((String)"update.sni.disabled.message", (Object[])new Object[0]);
            UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.WARNING, null).notify(null);
        }
    }

    private void scheduleOnStartCheck(Application app) {
        if (!this.mySettings.isCheckNeeded()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                if (willOpenProject == null) {
                    1.$$$reportNull$$$0(0);
                }
                BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
                BuildNumber lastBuildChecked = BuildNumber.fromString((String)UpdateCheckerComponent.this.mySettings.getLastBuildChecked());
                long timeSinceLastCheck = Math.max(System.currentTimeMillis() - UpdateCheckerComponent.this.mySettings.getLastTimeChecked(), 0L);
                if (lastBuildChecked == null || currentBuild.compareTo(lastBuildChecked) > 0 || timeSinceLastCheck >= 86400000L) {
                    UpdateCheckerComponent.this.myCheckRunnable.run();
                } else {
                    UpdateCheckerComponent.this.queueNextCheck(86400000L - timeSinceLastCheck);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$1", "appFrameCreated"));
            }
        });
    }

    private static void cleanupPatch() {
        new Task.Backgroundable(null, IdeBundle.message((String)"update.cleaning.patch.progress", (Object[])new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                UpdateInstaller.cleanupPatch();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$2", "run"));
            }
        }.queue();
    }

    private void queueNextCheck(long interval) {
        this.myCheckForUpdatesAlarm.addRequest(this.myCheckRunnable, interval);
    }

    public void initComponent() {
        UpdateCheckerComponent.checkIfPreviousUpdateFailed();
        PluginsAdvertiser.ensureDeleted();
    }

    private static void checkIfPreviousUpdateFailed() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (ApplicationInfo.getInstance().getBuild().asString().equals(properties.getValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY))) {
            File updateErrorsLog = new File(PathManager.getLogPath(), "idea_updater_error.log");
            try {
                if (updateErrorsLog.isFile() && !StringUtil.isEmptyOrSpaces((String)FileUtil.loadFile((File)updateErrorsLog))) {
                    FUSApplicationUsageTrigger.getInstance().trigger(IdeUpdateUsageTriggerCollector.class, "update.failed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        properties.setValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY, null);
    }

    public void dispose() {
    }

    public void queueNextCheck() {
        this.queueNextCheck(86400000L);
    }

    public void cancelChecks() {
        this.myCheckForUpdatesAlarm.cancelAllRequests();
    }

    private void snapPackageNotification(Application app) {
        if (!PathManager.isSnap() || !this.mySettings.isCheckNeeded()) {
            return;
        }
        app.executeOnPooledThread(() -> {
            BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
            BuildNumber lastBuildChecked = BuildNumber.fromString((String)this.mySettings.getLastBuildChecked());
            if (lastBuildChecked == null) {
                UpdateSettings.getInstance().saveLastCheckedInfo();
                return;
            }
            if (!currentBuild.equals((Object)lastBuildChecked)) {
                Product product;
                UpdatesInfo updatesInfo = null;
                try {
                    updatesInfo = UpdateChecker.getUpdatesInfo(UpdateSettings.getInstance());
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                String blogPost = null;
                if (updatesInfo != null && (product = updatesInfo.get(currentBuild.getProductCode())) != null) {
                    block2: for (UpdateChannel channel : product.getChannels()) {
                        for (BuildInfo build2 : channel.getBuilds()) {
                            if (!currentBuild.equals((Object)build2.getNumber())) continue;
                            blogPost = build2.getBlogPost();
                            break block2;
                        }
                    }
                }
                String message = blogPost == null ? IdeBundle.message((String)"update.snap.message", (Object[])new Object[0]) : IdeBundle.message((String)"update.snap.message.with.blog.post", (Object[])new Object[]{StringUtil.escapeXml(blogPost)});
                UpdateChecker.NOTIFICATIONS.createNotification(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]), message, NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER).notify(null);
                UpdateSettings.getInstance().saveLastCheckedInfo();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "app";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

