/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class UpdateSettingsConfigurable
implements SearchableConfigurable {
    private final UpdateSettings mySettings = UpdateSettings.getInstance();
    private final boolean myCheckNowEnabled;
    private UpdatesSettingsPanel myPanel;

    public UpdateSettingsConfigurable() {
        this(true);
    }

    public UpdateSettingsConfigurable(boolean checkNowEnabled) {
        this.myCheckNowEnabled = checkNowEnabled;
    }

    public JComponent createComponent() {
        this.myPanel = new UpdatesSettingsPanel(this.myCheckNowEnabled);
        return this.myPanel.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"updates.settings.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.updates" == null) {
            UpdateSettingsConfigurable.$$$reportNull$$$0(0);
        }
        return "preferences.updates";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            UpdateSettingsConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void apply() throws ConfigurationException {
        UpdateCheckerComponent checker;
        if (this.myPanel.myUseSecureConnection.isSelected() && !NetUtils.isSniEnabled()) {
            throw new ConfigurationException(IdeBundle.message((String)"update.sni.disabled.error", (Object[])new Object[0]));
        }
        boolean wasEnabled = this.mySettings.isCheckNeeded();
        this.mySettings.setCheckNeeded(this.myPanel.myCheckForUpdates.isSelected());
        if (wasEnabled != this.mySettings.isCheckNeeded() && (checker = (UpdateCheckerComponent)ApplicationManager.getApplication().getComponent(UpdateCheckerComponent.class)) != null) {
            if (wasEnabled) {
                checker.cancelChecks();
            } else {
                checker.queueNextCheck();
            }
        }
        this.mySettings.setSelectedChannelStatus(this.myPanel.getSelectedChannelType());
        this.mySettings.setSecureConnection(this.myPanel.myUseSecureConnection.isSelected());
    }

    public void reset() {
        this.myPanel.myCheckForUpdates.setSelected(this.mySettings.isCheckNeeded());
        this.myPanel.myUseSecureConnection.setSelected(this.mySettings.isSecureConnection());
        this.myPanel.updateLastCheckedLabel();
        this.myPanel.setSelectedChannelType(this.mySettings.getSelectedActiveChannel());
    }

    public boolean isModified() {
        if (this.myPanel == null) {
            return false;
        }
        if (this.mySettings.isCheckNeeded() != this.myPanel.myCheckForUpdates.isSelected() || this.mySettings.isSecureConnection() != this.myPanel.myUseSecureConnection.isSelected()) {
            return true;
        }
        Object channel = this.myPanel.myUpdateChannels.getSelectedItem();
        return channel != null && !channel.equals((Object)this.mySettings.getSelectedActiveChannel());
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UpdatesSettingsPanel {
        private final UpdateSettings mySettings;
        private JPanel myPanel;
        private JCheckBox myCheckForUpdates;
        private JComboBox<ChannelStatus> myUpdateChannels;
        private JButton myCheckNow;
        private JBLabel myChannelWarning;
        private JCheckBox myUseSecureConnection;
        private JLabel myBuildNumber;
        private JLabel myVersionNumber;
        private JLabel myLastCheckedDate;
        private ActionLink myIgnoredBuildsLink;

        public UpdatesSettingsPanel(boolean checkNowEnabled) {
            this.$$$setupUI$$$();
            this.mySettings = UpdateSettings.getInstance();
            ChannelStatus current = this.mySettings.getSelectedActiveChannel();
            this.myUpdateChannels.setModel((ComboBoxModel<ChannelStatus>)new CollectionComboBoxModel(this.mySettings.getActiveChannels(), (Object)current));
            String packageManager = this.mySettings.getPackageManagerName();
            if (packageManager != null) {
                this.myCheckForUpdates.setText(IdeBundle.message((String)"updates.settings.checkbox.external", (Object[])new Object[0]));
                this.myUpdateChannels.setVisible(false);
                this.myChannelWarning.setText(IdeBundle.message((String)"updates.settings.external", (Object[])new Object[]{packageManager}));
                this.myChannelWarning.setForeground((Color)JBColor.GRAY);
                this.myChannelWarning.setVisible(true);
                this.myChannelWarning.setBorder((Border)new JBEmptyBorder(0, 0, 10, 0));
            } else if (ApplicationInfoEx.getInstanceEx().isEAP() && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
                this.myUpdateChannels.setEnabled(false);
                this.myUpdateChannels.setToolTipText(IdeBundle.message((String)"updates.settings.channel.locked", (Object[])new Object[0]));
            } else {
                this.myUpdateChannels.addActionListener(e -> {
                    boolean lessStable = current.compareTo(this.getSelectedChannelType()) > 0;
                    this.myChannelWarning.setVisible(lessStable);
                });
                this.myChannelWarning.setForeground((Color)JBColor.RED);
            }
            if (checkNowEnabled) {
                this.myCheckNow.addActionListener(e -> {
                    Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myCheckNow));
                    UpdateSettings settings = new UpdateSettings();
                    settings.loadState(this.mySettings.getState());
                    settings.setSelectedChannelStatus(this.getSelectedChannelType());
                    settings.setSecureConnection(this.myUseSecureConnection.isSelected());
                    UpdateChecker.updateAndShowResult(project, settings);
                    this.updateLastCheckedLabel();
                });
            } else {
                this.myCheckNow.setVisible(false);
            }
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            this.myVersionNumber.setText(ApplicationNamesInfo.getInstance().getFullProductName() + ' ' + appInfo.getFullVersion());
            this.myBuildNumber.setText(appInfo.getBuild().asString());
        }

        private void createUIComponents() {
            this.myIgnoredBuildsLink = new ActionLink(IdeBundle.message((String)"updates.settings.ignored", (Object[])new Object[0]), new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    List<String> buildNumbers = mySettings.getIgnoredBuildNumbers();
                    String text2 = StringUtil.join(buildNumbers, (String)"\n");
                    String result2 = Messages.showMultilineInputDialog(null, null, (String)IdeBundle.message((String)"updates.settings.ignored.title", (Object[])new Object[0]), (String)text2, null, null);
                    if (result2 != null) {
                        buildNumbers.clear();
                        buildNumbers.addAll(StringUtil.split((String)result2, (String)"\n"));
                    }
                }
            });
        }

        private void updateLastCheckedLabel() {
            long time = this.mySettings.getLastTimeChecked();
            if (time <= 0L) {
                this.myLastCheckedDate.setText(IdeBundle.message((String)"updates.last.check.never", (Object[])new Object[0]));
            } else {
                this.myLastCheckedDate.setText(DateFormatUtil.formatPrettyDateTime((long)time));
                this.myLastCheckedDate.setToolTipText(DateFormatUtil.formatDate((long)time) + ' ' + DateFormatUtil.formatTimeWithSeconds((long)time));
            }
        }

        public ChannelStatus getSelectedChannelType() {
            return (ChannelStatus)((Object)this.myUpdateChannels.getSelectedItem());
        }

        public void setSelectedChannelType(ChannelStatus channelType) {
            this.myUpdateChannels.setSelectedItem((Object)(channelType != null ? channelType : ChannelStatus.RELEASE));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JLabel jLabel2;
            JLabel jLabel3;
            JCheckBox jCheckBox;
            JBLabel jBLabel;
            JButton jButton;
            JCheckBox jCheckBox2;
            JPanel jPanel;
            this.createUIComponents();
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myCheckForUpdates = jCheckBox2 = new JCheckBox();
            jCheckBox2.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.checkbox"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
            JComboBox jComboBox = new JComboBox();
            this.myUpdateChannels = jComboBox;
            jPanel.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myCheckNow = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.check.now.button"));
            jPanel.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myChannelWarning = jBLabel = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.unstable"));
            jBLabel.setVisible(false);
            jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 5, 8, 0, 0, 0, null, null, null));
            this.myUseSecureConnection = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.secure"));
            jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setText(" ");
            jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.last.check"));
            jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
            this.myLastCheckedDate = jLabel3 = new JLabel();
            jLabel3.setText("01.05.2005");
            jPanel.add((Component)jLabel3, new GridConstraints(4, 1, 1, 3, 8, 1, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.current.version"));
            jPanel.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
            this.myVersionNumber = jLabel2 = new JLabel();
            jLabel2.setText("4.5.4");
            jPanel.add((Component)jLabel2, new GridConstraints(5, 1, 1, 3, 8, 1, 0, 0, null, null, null));
            JLabel jLabel7 = new JLabel();
            this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.build.number"));
            jPanel.add((Component)jLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
            this.myBuildNumber = jLabel = new JLabel();
            jLabel.setText("3352");
            jPanel.add((Component)jLabel, new GridConstraints(6, 1, 1, 3, 8, 1, 0, 0, null, null, null));
            JLabel jLabel8 = new JLabel();
            jLabel8.setText(" ");
            jPanel.add((Component)jLabel8, new GridConstraints(7, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            ActionLink actionLink = this.myIgnoredBuildsLink;
            this.$$$loadLabelText$$$((JLabel)actionLink, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.ignored"));
            jPanel.add((Component)actionLink, new GridConstraints(8, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 4, 7, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(9, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

