/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistorySessionPartner
implements VcsAppendableHistorySessionPartner {
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final VcsHistoryProvider myVcsHistoryProvider;
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final VcsRevisionNumber myStartingRevisionNumber;
    @NotNull
    private final LimitHistoryCheck myLimitHistoryCheck;
    @NotNull
    private final FileHistoryRefresherI myRefresherI;
    @NotNull
    private final BufferedListConsumer<VcsFileRevision> myBuffer;
    private FileHistoryPanelImpl myFileHistoryPanel;
    private volatile VcsAbstractHistorySession mySession;

    public FileHistorySessionPartner(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, @NotNull AbstractVcs vcs, @NotNull FileHistoryRefresherI refresherI) {
        if (vcsHistoryProvider == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(0);
        }
        if (path == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(2);
        }
        if (refresherI == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(3);
        }
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myStartingRevisionNumber = startingRevisionNumber;
        this.myLimitHistoryCheck = new LimitHistoryCheck(vcs.getProject(), path.getPath());
        this.myVcs = vcs;
        this.myRefresherI = refresherI;
        Consumer sessionRefresher = vcsFileRevisions -> {
            this.mySession.getRevisionList().addAll(vcsFileRevisions);
            VcsHistorySession copy = this.mySession.copyWithCachedRevision();
            ApplicationManager.getApplication().invokeAndWait(() -> this.ensureHistoryPanelCreated().getHistoryPanelRefresh().consume((Object)copy));
        };
        this.myBuffer = new BufferedListConsumer<VcsFileRevision>(5, sessionRefresher, 1000){

            @Override
            protected void invokeConsumer(@NotNull Runnable consumerRunnable) {
                if (consumerRunnable == null) {
                    1.$$$reportNull$$$0(0);
                }
                consumerRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerRunnable", "com/intellij/openapi/vcs/history/FileHistorySessionPartner$1", "invokeConsumer"));
            }
        };
    }

    @Nullable
    static FileHistoryRefresherI findExistingHistoryRefresher(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber) {
        JComponent component;
        if (project == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(4);
        }
        if (path == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(5);
        }
        return (component = ContentUtilEx.findContentComponent(FileHistorySessionPartner.getToolWindow(project).getContentManager(), (Condition<JComponent>)((Condition)comp -> {
            if (path == null) {
                FileHistorySessionPartner.$$$reportNull$$$0(11);
            }
            return comp instanceof FileHistoryPanelImpl && FileHistoryPanelImpl.sameHistories((FileHistoryPanelImpl)((Object)((Object)comp)), path, startingRevisionNumber);
        }))) == null ? null : ((FileHistoryPanelImpl)((Object)component)).getRefresher();
    }

    public void acceptRevision(VcsFileRevision revision) {
        this.myLimitHistoryCheck.checkNumber();
        this.myBuffer.consumeOne(revision);
    }

    @NotNull
    private FileHistoryPanelImpl ensureHistoryPanelCreated() {
        if (this.myFileHistoryPanel == null) {
            this.myFileHistoryPanel = this.createFileHistoryPanel(this.mySession.copyWithCachedRevision());
        }
        FileHistoryPanelImpl fileHistoryPanelImpl = this.myFileHistoryPanel;
        if (fileHistoryPanelImpl == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(6);
        }
        return fileHistoryPanelImpl;
    }

    @NotNull
    private FileHistoryPanelImpl createFileHistoryPanel(@NotNull VcsHistorySession copy) {
        if (copy == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(7);
        }
        ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx(this.myVcs.getProject()).getContentManager();
        FileHistoryPanelImpl fileHistoryPanelImpl = new FileHistoryPanelImpl(this.myVcs, this.myPath, this.myStartingRevisionNumber, copy, this.myVcsHistoryProvider, contentManager, this.myRefresherI, false);
        if (fileHistoryPanelImpl == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(8);
        }
        return fileHistoryPanelImpl;
    }

    public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
        if (this.mySession != null && session2 != null && this.mySession.getRevisionList().equals(session2.getRevisionList())) {
            return;
        }
        this.mySession = session2;
        if (this.mySession != null) {
            this.mySession.shouldBeRefreshed();
            List revisionList = this.mySession.getRevisionList();
            while (this.myLimitHistoryCheck.isOver(revisionList.size())) {
                revisionList.remove(revisionList.size() - 1);
            }
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            VcsHistorySession copy = this.mySession.copyWithCachedRevision();
            if (this.myFileHistoryPanel == null) {
                this.myFileHistoryPanel = this.createFileHistoryPanel(copy);
                this.createOrSelectContentIfNeeded();
            } else if (session2 != null && !session2.getRevisionList().isEmpty()) {
                this.myFileHistoryPanel.getHistoryPanelRefresh().consume((Object)copy);
            }
        });
    }

    @NotNull
    private static ToolWindow getToolWindow(@NotNull Project project) {
        if (project == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(9);
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        assert (toolWindow != null) : "Version Control ToolWindow should be available at this point.";
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(10);
        }
        return toolWindow2;
    }

    public void reportException(VcsException exception) {
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myVcs.getProject(), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]) + ": " + exception.getMessage(), MessageType.ERROR);
    }

    public void beforeRefresh() {
        this.myLimitHistoryCheck.reset();
        if (this.myFileHistoryPanel != null) {
            this.createOrSelectContentIfNeeded();
        }
    }

    private void createOrSelectContentIfNeeded() {
        ToolWindow toolWindow = FileHistorySessionPartner.getToolWindow(this.myVcs.getProject());
        if (this.myRefresherI.isFirstTime()) {
            ContentManager manager = toolWindow.getContentManager();
            boolean selectedExistingContent = ContentUtilEx.selectContent(manager, (JComponent)((Object)this.myFileHistoryPanel), true);
            if (!selectedExistingContent) {
                String tabName = this.myPath.getName();
                if (this.myStartingRevisionNumber != null) {
                    tabName = tabName + " (" + VcsUtil.getShortRevisionString((VcsRevisionNumber)this.myStartingRevisionNumber) + ")";
                }
                ContentUtilEx.addTabbedContent(manager, (JComponent)((Object)this.myFileHistoryPanel), "History", tabName, true);
            }
            toolWindow.activate(null);
        }
    }

    public void finished() {
        this.myBuffer.flush();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.mySession == null) {
                return;
            }
            this.ensureHistoryPanelCreated().getHistoryPanelRefresh().finished();
        });
    }

    public void forceRefresh() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.mySession == null) {
                return;
            }
            this.ensureHistoryPanelCreated().scheduleRefresh(false);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsHistoryProvider";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresherI";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureHistoryPanelCreated";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileHistoryPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExistingHistoryRefresher";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileHistoryPanel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findExistingHistoryRefresher$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

