/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public abstract class OccurrencesChooser<T> {
    public static final String DEFAULT_CHOOSER_TITLE = "Multiple occurrences found";
    private final Set<RangeHighlighter> myRangeHighlighters = new HashSet<RangeHighlighter>();
    private final Editor myEditor;
    private final TextAttributes myAttributes;

    public static <T extends PsiElement> OccurrencesChooser<T> simpleChooser(Editor editor) {
        return new OccurrencesChooser<T>(editor){

            @Override
            protected TextRange getOccurrenceRange(T occurrence) {
                return occurrence.getTextRange();
            }
        };
    }

    public OccurrencesChooser(Editor editor) {
        this.myEditor = editor;
        this.myAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    public void showChooser(T selectedOccurrence, List<T> allOccurrences, Pass<ReplaceChoice> callback2) {
        if (allOccurrences.size() == 1) {
            callback2.pass((Object)ReplaceChoice.ALL);
        } else {
            LinkedHashMap occurrencesMap = ContainerUtil.newLinkedHashMap();
            occurrencesMap.put(ReplaceChoice.NO, Collections.singletonList(selectedOccurrence));
            occurrencesMap.put(ReplaceChoice.ALL, allOccurrences);
            this.showChooser(callback2, occurrencesMap);
        }
    }

    public void showChooser(Pass<ReplaceChoice> callback2, Map<ReplaceChoice, List<T>> occurrencesMap) {
        this.showChooser(callback2, occurrencesMap, DEFAULT_CHOOSER_TITLE);
    }

    public <C extends BaseReplaceChoice> void showChooser(Pass<C> callback2, final Map<C, List<T>> occurrencesMap, String title) {
        if (occurrencesMap.size() == 1) {
            callback2.pass(occurrencesMap.keySet().iterator().next());
            return;
        }
        List model = occurrencesMap.keySet().stream().collect(Collectors.toList());
        JBPopupFactory.getInstance().createPopupChooserBuilder(model).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                BaseReplaceChoice choices = (BaseReplaceChoice)value;
                if (choices != null) {
                    this.setText(choices.formatDescription(((List)occurrencesMap.get(choices)).size()));
                }
                return rendererComponent;
            }
        }).setItemSelectedCallback(value -> {
            if (value == null) {
                return;
            }
            this.dropHighlighters();
            MarkupModel markupModel = this.myEditor.getMarkupModel();
            List occurrenceList = (List)occurrencesMap.get(value);
            for (Object occurrence : occurrenceList) {
                TextRange textRange = this.getOccurrenceRange(occurrence);
                RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                this.myRangeHighlighters.add(rangeHighlighter);
            }
        }).setTitle(title).setMovable(true).setResizable(false).setRequestFocus(true).setItemChosenCallback(arg_0 -> callback2.pass(arg_0)).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                OccurrencesChooser.this.dropHighlighters();
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    protected abstract TextRange getOccurrenceRange(T var1);

    private void dropHighlighters() {
        for (RangeHighlighter highlight : this.myRangeHighlighters) {
            highlight.dispose();
        }
        this.myRangeHighlighters.clear();
    }

    public static enum ReplaceChoice implements BaseReplaceChoice
    {
        NO("Replace this occurrence only"),
        NO_WRITE("Replace all occurrences but write"),
        ALL("Replace all {0} occurrences");

        private final String myDescription;

        private ReplaceChoice(String description) {
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }

        @Override
        public boolean isMultiple() {
            return this == NO_WRITE || this == ALL;
        }

        @Override
        public boolean isAll() {
            return this == ALL;
        }

        @Override
        public String formatDescription(int occurrencesCount) {
            return MessageFormat.format(this.getDescription(), occurrencesCount);
        }
    }

    public static interface BaseReplaceChoice {
        public boolean isMultiple();

        public boolean isAll();

        public String formatDescription(int var1);
    }
}

