/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;

public class MoveMultipleElementsViewDescriptor
implements UsageViewDescriptor {
    private final PsiElement[] myPsiElements;
    private String myProcessedElementsHeader;
    private final String myCodeReferencesText;

    public MoveMultipleElementsViewDescriptor(PsiElement[] psiElements, String targetName) {
        this.myPsiElements = psiElements;
        if (psiElements.length == 1) {
            this.myProcessedElementsHeader = StringUtil.capitalize((String)RefactoringBundle.message((String)"move.single.element.elements.header", (Object[])new Object[]{UsageViewUtil.getType(psiElements[0]), targetName}));
            this.myCodeReferencesText = RefactoringBundle.message((String)"references.in.code.to.0.1", (Object[])new Object[]{UsageViewUtil.getType(psiElements[0]), UsageViewUtil.getLongName(psiElements[0])});
        } else {
            if (psiElements.length > 0) {
                this.myProcessedElementsHeader = StringUtil.capitalize((String)RefactoringBundle.message((String)"move.single.element.elements.header", (Object[])new Object[]{StringUtil.pluralize((String)UsageViewUtil.getType(psiElements[0])), targetName}));
            }
            this.myCodeReferencesText = RefactoringBundle.message((String)"references.found.in.code");
        }
    }

    @NotNull
    public PsiElement[] getElements() {
        if (this.myPsiElements == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(0);
        }
        return this.myPsiElements;
    }

    public String getProcessedElementsHeader() {
        return this.myProcessedElementsHeader;
    }

    public String getCodeReferencesText(int usagesCount, int filesCount) {
        return this.myCodeReferencesText + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
    }

    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message((String)"comments.elements.header", (Object[])new Object[]{UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/MoveMultipleElementsViewDescriptor", "getElements"));
    }
}

