/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"safe.delete.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            SafeDeleteHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null || !SafeDeleteProcessor.validElement(element)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.safeDelete");
            return;
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            SafeDeleteHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(2);
        }
        SafeDeleteHandler.invoke(project, elements, (Module)LangDataKeys.MODULE.getData(dataContext), true, null, null);
    }

    public static void invoke(Project project, PsiElement[] elements, boolean checkDelegates) {
        SafeDeleteHandler.invoke(project, elements, checkDelegates, null);
    }

    public static void invoke(Project project, PsiElement[] elements, boolean checkDelegates, @Nullable Runnable successRunnable) {
        SafeDeleteHandler.invoke(project, elements, null, checkDelegates, successRunnable, null);
    }

    public static void invoke(Project project, PsiElement[] elements, @Nullable Module module2, boolean checkDelegates, @Nullable Runnable successRunnable) {
        SafeDeleteHandler.invoke(project, elements, module2, checkDelegates, successRunnable, null);
    }

    public static void invoke(final Project project, PsiElement[] elements, @Nullable Module module2, boolean checkDelegates, final @Nullable Runnable successRunnable, final @Nullable Runnable afterRefactoring) {
        for (PsiElement psiElement : elements) {
            if (SafeDeleteProcessor.validElement(psiElement)) continue;
            return;
        }
        Object[] temptoDelete = PsiTreeUtil.filterAncestors((PsiElement[])elements);
        HashSet<PsiElement> elementsSet = new HashSet<PsiElement>(Arrays.asList(temptoDelete));
        LinkedHashSet<Object> fullElementsSet = new LinkedHashSet<Object>();
        if (checkDelegates) {
            for (Object element : temptoDelete) {
                boolean found = false;
                for (SafeDeleteProcessorDelegate delegate : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
                    Collection<? extends PsiElement> addElements;
                    if (!delegate.handlesElement((PsiElement)element)) continue;
                    found = true;
                    Collection<? extends PsiElement> collection = addElements = delegate instanceof SafeDeleteProcessorDelegateBase ? ((SafeDeleteProcessorDelegateBase)delegate).getElementsToSearch((PsiElement)element, module2, elementsSet) : delegate.getElementsToSearch((PsiElement)element, elementsSet);
                    if (addElements == null) {
                        return;
                    }
                    fullElementsSet.addAll(addElements);
                    break;
                }
                if (found) continue;
                fullElementsSet.add(element);
            }
        } else {
            ContainerUtil.addAll(fullElementsSet, (Object[])temptoDelete);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, fullElementsSet, (boolean)true)) {
            return;
        }
        final PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(fullElementsSet);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RefactoringSettings settings = RefactoringSettings.getInstance();
            SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project, null, psiElementArray, settings.SAFE_DELETE_SEARCH_IN_COMMENTS, settings.SAFE_DELETE_SEARCH_IN_NON_JAVA, true);
            if (afterRefactoring != null) {
                processor2.setAfterRefactoringCallback(afterRefactoring);
            }
            processor2.run();
            if (successRunnable != null) {
                successRunnable.run();
            }
        } else {
            SafeDeleteDialog.Callback callback2 = new SafeDeleteDialog.Callback(){

                @Override
                public void run(SafeDeleteDialog dialog2) {
                    SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project, () -> {
                        if (successRunnable != null) {
                            successRunnable.run();
                        }
                        dialog2.close(1);
                    }, psiElementArray, dialog2.isSearchInComments(), dialog2.isSearchForTextOccurences(), true);
                    if (afterRefactoring != null) {
                        processor2.setAfterRefactoringCallback(afterRefactoring);
                    }
                    processor2.run();
                }
            };
            SafeDeleteDialog dialog2 = new SafeDeleteDialog(project, psiElementArray, callback2);
            dialog2.show();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/safeDelete/SafeDeleteHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

