/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;

public class PsiErrorElementUtil {
    private static final Key<CachedValue<Boolean>> CONTAINS_ERROR_ELEMENT = Key.create((String)"CONTAINS_ERROR_ELEMENT");

    private PsiErrorElementUtil() {
    }

    public static boolean hasErrors(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            PsiErrorElementUtil.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            PsiErrorElementUtil.$$$reportNull$$$0(1);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project == null) {
                PsiErrorElementUtil.$$$reportNull$$$0(7);
            }
            if (virtualFile == null) {
                PsiErrorElementUtil.$$$reportNull$$$0(8);
            }
            if (project.isDisposed() || !virtualFile.isValid()) {
                return false;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            return psiFile != null && PsiErrorElementUtil.hasErrors(psiFile);
        });
    }

    private static boolean hasErrors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PsiErrorElementUtil.$$$reportNull$$$0(2);
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)psiFile.getProject());
        return (Boolean)cachedValuesManager.getCachedValue((UserDataHolder)psiFile, CONTAINS_ERROR_ELEMENT, () -> {
            if (psiFile == null) {
                PsiErrorElementUtil.$$$reportNull$$$0(6);
            }
            return CachedValueProvider.Result.create((Object)PsiErrorElementUtil.hasErrorElements((PsiElement)psiFile), (Object[])new Object[]{psiFile});
        }, false);
    }

    private static boolean hasErrorElements(@NotNull PsiElement element) {
        if (element == null) {
            PsiErrorElementUtil.$$$reportNull$$$0(3);
        }
        HighlightErrorFilter[] filters = null;
        for (PsiErrorElement error : SyntaxTraverser.psiTraverser((PsiElement)element).traverse().filter(PsiErrorElement.class)) {
            if (filters == null) {
                filters = (HighlightErrorFilter[])HighlightErrorFilter.EP_NAME.getExtensions((AreaInstance)element.getProject());
            }
            if (!PsiErrorElementUtil.shouldHighlightErrorElement(error, filters)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldHighlightErrorElement(@NotNull PsiErrorElement error, @NotNull HighlightErrorFilter[] filters) {
        if (error == null) {
            PsiErrorElementUtil.$$$reportNull$$$0(4);
        }
        if (filters == null) {
            PsiErrorElementUtil.$$$reportNull$$$0(5);
        }
        for (HighlightErrorFilter filter : filters) {
            if (filter.shouldHighlightErrorElement(error)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/PsiErrorElementUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrorElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasErrors$1";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasErrors$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

