/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsWatcher
implements Disposable {
    private static final String TOOLWINDOW_ID = ChangesViewContentManager.TOOLWINDOW_ID;
    private static final Logger LOG = Logger.getInstance(VcsLogTabsWatcher.class);
    @NotNull
    private final PostponableLogRefresher myRefresher;
    @NotNull
    private final ToolWindowManagerEx myToolWindowManager;
    @NotNull
    private final MyRefreshPostponedEventsListener myPostponedEventsListener;
    @Nullable
    private ToolWindow myToolWindow;
    private boolean myIsVisible;
    @Nullable
    private MessageBusConnection myConnection;

    public VcsLogTabsWatcher(@NotNull Project project, @NotNull PostponableLogRefresher refresher) {
        if (project == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(0);
        }
        if (refresher == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(1);
        }
        this.myRefresher = refresher;
        this.myToolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        this.myPostponedEventsListener = new MyRefreshPostponedEventsListener();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                VcsLogTabsWatcher.$$$reportNull$$$0(6);
            }
            this.myConnection = project.getMessageBus().connect();
            this.myConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)this.myPostponedEventsListener);
            this.installContentListener();
        }, project.getDisposed());
    }

    @Nullable
    private String getSelectedTabId() {
        Content content;
        if (this.myToolWindow != null && this.myToolWindow.isVisible() && (content = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            return VcsLogContentUtil.getId(content);
        }
        return null;
    }

    @NotNull
    public Disposable addTabToWatch(@NotNull String tabId, @NotNull VisiblePackRefresher refresher) {
        if (tabId == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(3);
        }
        Disposable disposable = this.myRefresher.addLogWindow(new VcsLogTab(refresher, tabId));
        if (disposable == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(4);
        }
        return disposable;
    }

    private void installContentListener() {
        ToolWindow window = this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (window != null) {
            this.myToolWindow = window;
            this.myIsVisible = this.myToolWindow.isVisible();
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
        }
    }

    private void removeListeners() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
        if (this.myToolWindow != null) {
            this.myToolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            for (Content content : this.myToolWindow.getContentManager().getContents()) {
                if (!(content instanceof TabbedContent)) continue;
                content.removePropertyChangeListener((PropertyChangeListener)this.myPostponedEventsListener);
            }
        }
    }

    public void closeLogTabs() {
        if (this.myToolWindow != null) {
            List<String> tabs2 = this.getTabs();
            for (String tabId : tabs2) {
                boolean closed = VcsLogContentUtil.closeLogTab(this.myToolWindow.getContentManager(), tabId);
                LOG.assertTrue(closed, (Object)("Could not find content component for tab " + tabId + "\nExisting content: " + Arrays.toString(this.myToolWindow.getContentManager().getContents()) + "\nTabs to close: " + tabs2));
            }
        }
    }

    @NotNull
    private List<String> getTabs() {
        List list2 = ((StreamEx)StreamEx.of(this.myRefresher.getLogWindows()).select(VcsLogTab.class).map(VcsLogTab::getTabId).filter(tabId -> !"MAIN".equals(tabId))).toList();
        if (list2 == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public void dispose() {
        this.removeListeners();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addTabToWatch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTabToWatch";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRefreshPostponedEventsListener
    extends ContentManagerAdapter
    implements ToolWindowManagerListener,
    PropertyChangeListener {
        private MyRefreshPostponedEventsListener() {
        }

        private void selectionChanged() {
            String tabId = VcsLogTabsWatcher.this.getSelectedTabId();
            if (tabId != null) {
                this.selectionChanged(tabId);
            }
        }

        private void selectionChanged(@NotNull String tabId) {
            PostponableLogRefresher.VcsLogWindow logWindow;
            if (tabId == null) {
                MyRefreshPostponedEventsListener.$$$reportNull$$$0(0);
            }
            if ((logWindow = (PostponableLogRefresher.VcsLogWindow)ContainerUtil.find(VcsLogTabsWatcher.this.myRefresher.getLogWindows(), window -> {
                if (tabId == null) {
                    MyRefreshPostponedEventsListener.$$$reportNull$$$0(2);
                }
                return window instanceof VcsLogTab && ((VcsLogTab)window).myTabId.equals(tabId);
            })) != null) {
                VcsLogTabsWatcher.this.myRefresher.refresherActivated(logWindow.getRefresher(), false);
            }
        }

        public void selectionChanged(ContentManagerEvent event) {
            String tabId;
            if (ContentManagerEvent.ContentOperation.add.equals((Object)event.getOperation()) && (tabId = VcsLogContentUtil.getId(event.getContent())) != null) {
                this.selectionChanged(tabId);
            }
        }

        public void contentAdded(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content instanceof TabbedContent) {
                content.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content instanceof TabbedContent) {
                content.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void stateChanged() {
            if (VcsLogTabsWatcher.this.myToolWindow == null) {
                return;
            }
            if (VcsLogTabsWatcher.this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID) == null) {
                VcsLogTabsWatcher.this.removeListeners();
            } else if (VcsLogTabsWatcher.this.myIsVisible != VcsLogTabsWatcher.this.myToolWindow.isVisible()) {
                VcsLogTabsWatcher.this.myIsVisible = VcsLogTabsWatcher.this.myToolWindow.isVisible();
                this.selectionChanged();
            }
        }

        @Override
        public void toolWindowRegistered(@NotNull String toolWindowId) {
            if (toolWindowId == null) {
                MyRefreshPostponedEventsListener.$$$reportNull$$$0(1);
            }
            if (toolWindowId.equals(TOOLWINDOW_ID)) {
                VcsLogTabsWatcher.this.installContentListener();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("component")) {
                this.selectionChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$MyRefreshPostponedEventsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toolWindowRegistered";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$selectionChanged$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class VcsLogTab
    extends PostponableLogRefresher.VcsLogWindow {
        @NotNull
        private final String myTabId;

        public VcsLogTab(@NotNull VisiblePackRefresher refresher, String tabId) {
            if (refresher == null) {
                VcsLogTab.$$$reportNull$$$0(0);
            }
            if (tabId == null) {
                VcsLogTab.$$$reportNull$$$0(1);
            }
            super(refresher);
            this.myTabId = tabId;
        }

        @Override
        public boolean isVisible() {
            String selectedTab = VcsLogTabsWatcher.this.getSelectedTabId();
            return selectedTab != null && this.myTabId.equals(selectedTab);
        }

        @NotNull
        public String getTabId() {
            String string = this.myTabId;
            if (string == null) {
                VcsLogTab.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refresher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogTab";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogTab";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

