/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.CachedValueProviderOnPsiFile;
import com.jetbrains.jsonSchema.impl.JsonSchemaFileValuesIndex;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonCachedValues {
    private static final Key<CachedValue<JsonSchemaObject>> JSON_OBJECT_CACHE_KEY = Key.create((String)"JsonSchemaObjectCache");
    static final String URL_CACHE_KEY = "JsonSchemaUrlCache";
    private static final Key<CachedValue<String>> SCHEMA_URL_KEY = Key.create((String)"JsonSchemaUrlCache");
    static final String ID_CACHE_KEY = "JsonSchemaIdCache";
    private static final Key<CachedValue<String>> SCHEMA_ID_CACHE_KEY = Key.create((String)"JsonSchemaIdCache");
    private static final Key<CachedValue<List<Pair<Collection<String>, String>>>> SCHEMA_CATALOG_CACHE_KEY = Key.create((String)"JsonSchemaCatalogCache");

    @Nullable
    public static JsonSchemaObject getSchemaObject(@NotNull VirtualFile schemaFile, @NotNull Project project) {
        if (schemaFile == null) {
            JsonCachedValues.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JsonCachedValues.$$$reportNull$$$0(1);
        }
        JsonFileResolver.startFetchingHttpFileIfNeeded(schemaFile, project);
        PsiFile psiFile = JsonCachedValues.resolveFile(schemaFile, project);
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        return CachedValueProviderOnPsiFile.getOrCompute(psiFile, JsonCachedValues::computeSchemaObject, JSON_OBJECT_CACHE_KEY);
    }

    @Nullable
    private static JsonSchemaObject computeSchemaObject(@NotNull PsiFile f) {
        JsonObject topLevelValue;
        if (f == null) {
            JsonCachedValues.$$$reportNull$$$0(2);
        }
        if ((topLevelValue = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)f).getTopLevelValue(), JsonObject.class)) != null) {
            return new JsonSchemaReader().read(topLevelValue);
        }
        return null;
    }

    @Nullable
    public static String getSchemaUrlFromSchemaProperty(@NotNull VirtualFile file2, @NotNull Project project) {
        String value;
        if (file2 == null) {
            JsonCachedValues.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JsonCachedValues.$$$reportNull$$$0(4);
        }
        if ((value = JsonSchemaFileValuesIndex.getCachedValue(project, file2, URL_CACHE_KEY)) != null) {
            return "$NULL$".equals(value) ? null : value;
        }
        PsiFile psiFile = JsonCachedValues.resolveFile(file2, project);
        return !(psiFile instanceof JsonFile) ? null : CachedValueProviderOnPsiFile.getOrCompute(psiFile, JsonCachedValues::fetchSchemaUrl, SCHEMA_URL_KEY);
    }

    private static PsiFile resolveFile(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            JsonCachedValues.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JsonCachedValues.$$$reportNull$$$0(6);
        }
        if (project.isDisposed() || !file2.isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(file2);
    }

    @Nullable
    static String fetchSchemaUrl(@Nullable PsiFile f) {
        if (!(f instanceof JsonFile)) {
            return null;
        }
        JsonValue topLevelValue = ((JsonFile)f).getTopLevelValue();
        if (!(topLevelValue instanceof JsonObject)) {
            return null;
        }
        JsonProperty schema = ((JsonObject)topLevelValue).findProperty("$schema");
        if (schema == null) {
            return null;
        }
        JsonValue value = schema.getValue();
        return value instanceof JsonStringLiteral ? ((JsonStringLiteral)value).getValue() : null;
    }

    @Nullable
    public static String getSchemaId(@NotNull VirtualFile schemaFile, @NotNull Project project) {
        String value;
        if (schemaFile == null) {
            JsonCachedValues.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JsonCachedValues.$$$reportNull$$$0(8);
        }
        if ((value = JsonSchemaFileValuesIndex.getCachedValue(project, schemaFile, ID_CACHE_KEY)) != null) {
            return "$NULL$".equals(value) ? null : value;
        }
        PsiFile psiFile = JsonCachedValues.resolveFile(schemaFile, project);
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        return CachedValueProviderOnPsiFile.getOrCompute(psiFile, JsonCachedValues::fetchSchemaId, SCHEMA_ID_CACHE_KEY);
    }

    @Nullable
    static String fetchSchemaId(@NotNull PsiFile psiFile) {
        JsonObject topLevelValue;
        if (psiFile == null) {
            JsonCachedValues.$$$reportNull$$$0(9);
        }
        return (topLevelValue = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)psiFile).getTopLevelValue(), JsonObject.class)) == null ? null : JsonCachedValues.readId(topLevelValue);
    }

    @Nullable
    private static String readId(@NotNull JsonObject object) {
        String idPropertyV6;
        if (object == null) {
            JsonCachedValues.$$$reportNull$$$0(10);
        }
        if ((idPropertyV6 = JsonCachedValues.readIdProperty(object, "$id")) != null) {
            return idPropertyV6;
        }
        return JsonCachedValues.readIdProperty(object, "id");
    }

    @Nullable
    private static String readIdProperty(@NotNull JsonObject object, @NotNull String id) {
        JsonProperty property;
        if (object == null) {
            JsonCachedValues.$$$reportNull$$$0(11);
        }
        if (id == null) {
            JsonCachedValues.$$$reportNull$$$0(12);
        }
        if ((property = object.findProperty(id)) != null && property.getValue() instanceof JsonStringLiteral) {
            return JsonSchemaService.normalizeId(StringUtil.unquoteString((String)property.getValue().getText()));
        }
        return null;
    }

    @Nullable
    public static List<Pair<Collection<String>, String>> getSchemaCatalog(@NotNull VirtualFile catalog, @NotNull Project project) {
        if (catalog == null) {
            JsonCachedValues.$$$reportNull$$$0(13);
        }
        if (project == null) {
            JsonCachedValues.$$$reportNull$$$0(14);
        }
        if (!catalog.isValid()) {
            return null;
        }
        PsiFile psiFile = JsonCachedValues.resolveFile(catalog, project);
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        return CachedValueProviderOnPsiFile.getOrCompute(psiFile, JsonCachedValues::computeSchemaCatalog, SCHEMA_CATALOG_CACHE_KEY);
    }

    private static List<Pair<Collection<String>, String>> computeSchemaCatalog(PsiFile catalog) {
        JsonValue value = ((JsonFile)catalog).getTopLevelValue();
        if (!(value instanceof JsonObject)) {
            return null;
        }
        JsonProperty schemas = ((JsonObject)value).findProperty("schemas");
        if (schemas == null) {
            return null;
        }
        JsonValue schemasValue = schemas.getValue();
        if (!(schemasValue instanceof JsonArray)) {
            return null;
        }
        ArrayList catalogMap = ContainerUtil.newArrayList();
        JsonCachedValues.fillMap((JsonArray)schemasValue, catalogMap);
        return catalogMap;
    }

    private static void fillMap(@NotNull JsonArray array, @NotNull List<Pair<Collection<String>, String>> catalogMap) {
        if (array == null) {
            JsonCachedValues.$$$reportNull$$$0(15);
        }
        if (catalogMap == null) {
            JsonCachedValues.$$$reportNull$$$0(16);
        }
        for (JsonValue value : array.getValueList()) {
            String urlStringValue;
            JsonValue urlValue;
            List masks;
            if (!(value instanceof JsonObject)) continue;
            JsonProperty fileMatch = ((JsonObject)value).findProperty("fileMatch");
            Collection<Object> collection = masks = fileMatch == null ? ContainerUtil.emptyList() : JsonCachedValues.resolveMasks(fileMatch.getValue());
            JsonProperty url = ((JsonObject)value).findProperty("url");
            if (url == null || !((urlValue = url.getValue()) instanceof JsonStringLiteral) || StringUtil.isEmpty((String)(urlStringValue = ((JsonStringLiteral)urlValue).getValue()))) continue;
            catalogMap.add((Pair<Collection<String>, String>)Pair.create((Object)masks, (Object)urlStringValue));
        }
    }

    @NotNull
    private static Collection<String> resolveMasks(@Nullable JsonValue value) {
        if (value instanceof JsonStringLiteral) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)((JsonStringLiteral)value).getValue());
            if (list2 == null) {
                JsonCachedValues.$$$reportNull$$$0(17);
            }
            return list2;
        }
        if (value instanceof JsonArray) {
            ArrayList strings = ContainerUtil.newArrayList();
            for (JsonValue val : ((JsonArray)value).getValueList()) {
                if (!(val instanceof JsonStringLiteral)) continue;
                strings.add(((JsonStringLiteral)val).getValue());
            }
            ArrayList arrayList = strings;
            if (arrayList == null) {
                JsonCachedValues.$$$reportNull$$$0(18);
            }
            return arrayList;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            JsonCachedValues.$$$reportNull$$$0(19);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalog";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogMap";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonCachedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonCachedValues";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeSchemaObject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaUrlFromSchemaProperty";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fetchSchemaId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readId";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readIdProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaCatalog";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

