/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyParameterInfoHandler
implements ParameterInfoHandler<PyArgumentList, Pair<PyCallExpression, PyCallExpression.PyMarkedCallee>> {
    @NotNull
    private static final String NO_PARAMS_MSG = CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);

    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public PyArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        PyCallExpression call;
        PyArgumentList argumentList;
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if ((argumentList = PyParameterInfoHandler.findArgumentList((ParameterInfoContext)context, -1)) != null && (call = argumentList.getCallExpression()) != null) {
            TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(argumentList.getProject(), argumentList.getContainingFile());
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withRemote().withTypeEvalContext(typeEvalContext);
            context.setItemsToShow(PyUtil.filterTopPriorityResults(call.multiResolveCallee(resolveContext)).stream().filter(markedCallee -> markedCallee.getCallableType().getParameters(typeEvalContext) != null).map(markedCallee -> Pair.createNonNull((Object)call, (Object)markedCallee)).toArray());
            return argumentList;
        }
        return null;
    }

    @Nullable
    private static PyArgumentList findArgumentList(@NotNull ParameterInfoContext context, int parameterListStart) {
        PyArgumentList argumentList;
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if ((argumentList = (PyArgumentList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)(context.getOffset() - 1), PyArgumentList.class)) != null && parameterListStart >= 0 && argumentList.getTextRange().getStartOffset() != parameterListStart) {
            return (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)argumentList, PyArgumentList.class);
        }
        return argumentList;
    }

    public void showParameterInfo(@NotNull PyArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(4);
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public PyArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(5);
        }
        return PyParameterInfoHandler.findArgumentList((ParameterInfoContext)context, context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull PyArgumentList argumentList, @NotNull UpdateParameterInfoContext context) {
        if (argumentList == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if (context.getParameterOwner() != argumentList) {
            context.removeHint();
            return;
        }
        List<PyExpression> flattenedArguments = PyUtil.flattenedParensAndLists(argumentList.getArguments());
        int allegedCursorOffset = context.getOffset();
        if (!argumentList.getTextRange().contains(allegedCursorOffset) && argumentList.getText().endsWith(")")) {
            context.removeHint();
            return;
        }
        PsiFile file2 = context.getFile();
        CharSequence chars = file2.getViewProvider().getContents();
        int offset = -1;
        for (PyExpression argument : flattenedArguments) {
            TextRange range2 = argument.getTextRange();
            int left = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(range2.getStartOffset() - 1), (String)" \t\r\n");
            int right = CharArrayUtil.shiftForwardCarefully((CharSequence)chars, (int)range2.getEndOffset(), (String)" \t\r\n");
            if (argument.getParent() instanceof PyListLiteralExpression || argument.getParent() instanceof PyTupleExpression) {
                right = CharArrayUtil.shiftForward((CharSequence)chars, (int)range2.getEndOffset(), (String)" \t\r\n])");
            }
            if (left > allegedCursorOffset || right < allegedCursorOffset) continue;
            offset = range2.getStartOffset();
            break;
        }
        context.setCurrentParameter(offset);
    }

    public void updateUI(@NotNull Pair<PyCallExpression, PyCallExpression.PyMarkedCallee> callAndCallee, @NotNull ParameterInfoUIContext context) {
        if (callAndCallee == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(9);
        }
        PyCallExpression callExpression = (PyCallExpression)callAndCallee.getFirst();
        PyPsiUtils.assertValid((PsiElement)callExpression);
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(callExpression.getProject(), callExpression.getContainingFile());
        PyCallExpression.PyMarkedCallee markedCallee = (PyCallExpression.PyMarkedCallee)callAndCallee.getSecond();
        List<PyCallableParameter> parameters2 = markedCallee.getCallableType().getParameters(typeEvalContext);
        if (parameters2 == null) {
            return;
        }
        PyCallExpression.PyArgumentsMapping mapping = PyCallExpressionHelper.mapArguments(callExpression, markedCallee, typeEvalContext);
        if (mapping.getMarkedCallee() == null) {
            return;
        }
        HashMap<Integer, PyCallableParameter> indexToNamedParameter = new HashMap<Integer, PyCallableParameter>(parameters2.size());
        HashMap<PyCallableParameter, Integer> parameterToHintIndex = new HashMap<PyCallableParameter, Integer>();
        HashMap<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags = new HashMap<Integer, EnumSet<ParameterInfoUIContextEx.Flag>>();
        List<String> hintsList = PyParameterInfoHandler.buildParameterListHint(parameters2, indexToNamedParameter, parameterToHintIndex, hintFlags, typeEvalContext);
        int currentParamOffset = context.getCurrentParameterIndex();
        for (int i = 0; i < markedCallee.getImplicitOffset(); ++i) {
            if (!indexToNamedParameter.containsKey(i)) continue;
            PyCallableParameter parameter = (PyCallableParameter)indexToNamedParameter.get(i);
            ((EnumSet)hintFlags.get(parameterToHintIndex.get(parameter))).add(ParameterInfoUIContextEx.Flag.DISABLE);
        }
        List<PyExpression> flattenedArguments = PyUtil.flattenedParensAndLists(callExpression.getArguments());
        int lastParamIndex = PyParameterInfoHandler.collectHighlights(mapping, parameters2, parameterToHintIndex, hintFlags, flattenedArguments, currentParamOffset);
        PyParameterInfoHandler.highlightNext(markedCallee, parameters2, indexToNamedParameter, parameterToHintIndex, hintFlags, flattenedArguments.isEmpty(), lastParamIndex);
        String[] hints = ArrayUtil.toStringArray(hintsList);
        if (context instanceof ParameterInfoUIContextEx) {
            ParameterInfoUIContextEx pic = (ParameterInfoUIContextEx)context;
            EnumSet[] flags = new EnumSet[hintFlags.size()];
            for (int i = 0; i < flags.length; ++i) {
                flags[i] = (EnumSet)hintFlags.get(i);
            }
            if (hints.length < 1) {
                hints = new String[]{NO_PARAMS_MSG};
                flags = new EnumSet[]{EnumSet.of(ParameterInfoUIContextEx.Flag.DISABLE)};
            }
            pic.setupUIComponentPresentation(hints, flags, context.getDefaultParameterColor());
        } else {
            StringBuilder signatureBuilder = new StringBuilder();
            if (hints.length > 1) {
                for (String s : hints) {
                    signatureBuilder.append(s);
                }
            } else {
                signatureBuilder.append(XmlStringUtil.escapeString((String)NO_PARAMS_MSG));
            }
            context.setupUIComponentPresentation(signatureBuilder.toString(), -1, 0, false, false, false, context.getDefaultParameterColor());
        }
    }

    private static void highlightNext(@NotNull PyCallExpression.PyMarkedCallee marked, @NotNull List<PyCallableParameter> parameterList, @NotNull Map<Integer, PyCallableParameter> indexToNamedParameter, @NotNull Map<PyCallableParameter, Integer> parameterToHintIndex, @NotNull Map<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags, boolean isArgsEmpty, int lastParamIndex) {
        if (marked == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (parameterList == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (indexToNamedParameter == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if (parameterToHintIndex == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(13);
        }
        if (hintFlags == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(14);
        }
        boolean canOfferNext = true;
        for (EnumSet<ParameterInfoUIContextEx.Flag> set2 : hintFlags.values()) {
            if (!set2.contains(ParameterInfoUIContextEx.Flag.HIGHLIGHT)) continue;
            canOfferNext = false;
        }
        if (canOfferNext) {
            PyCallableParameter parameter;
            int highlightIndex = Integer.MAX_VALUE;
            if (isArgsEmpty) {
                highlightIndex = marked.getImplicitOffset();
            } else if (lastParamIndex < parameterList.size() - 1) {
                highlightIndex = !indexToNamedParameter.containsKey(lastParamIndex) || indexToNamedParameter.get(lastParamIndex).isPositionalContainer() ? lastParamIndex : lastParamIndex + 1;
            } else if (lastParamIndex == parameterList.size() - 1 && ((parameter = indexToNamedParameter.get(lastParamIndex)).isPositionalContainer() || parameter.isKeywordContainer())) {
                highlightIndex = lastParamIndex;
            }
            if (indexToNamedParameter.containsKey(highlightIndex)) {
                hintFlags.get(parameterToHintIndex.get(indexToNamedParameter.get(highlightIndex))).add(ParameterInfoUIContextEx.Flag.HIGHLIGHT);
            }
        }
    }

    private static int collectHighlights(@NotNull PyCallExpression.PyArgumentsMapping mapping, @NotNull List<PyCallableParameter> parameterList, @NotNull Map<PyCallableParameter, Integer> parameterHintToIndex, @NotNull Map<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags, @NotNull List<PyExpression> flatArgs, int currentParamOffset) {
        if (mapping == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(15);
        }
        if (parameterList == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(16);
        }
        if (parameterHintToIndex == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(17);
        }
        if (hintFlags == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(18);
        }
        if (flatArgs == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(19);
        }
        PyCallExpression.PyMarkedCallee callee = mapping.getMarkedCallee();
        assert (callee != null);
        int lastParamIndex = callee.getImplicitOffset();
        Map<PyExpression, PyCallableParameter> mappedParameters = mapping.getMappedParameters();
        Map<PyExpression, PyCallableParameter> mappedTupleParameters = mapping.getMappedTupleParameters();
        for (PyExpression arg : flatArgs) {
            boolean mustHighlight = arg.getTextRange().contains(currentParamOffset);
            PyExpression seeker = arg;
            while (!(seeker instanceof PyArgumentList) && seeker instanceof PyExpression && !mappedParameters.containsKey(seeker)) {
                seeker = seeker.getParent();
            }
            if (seeker instanceof PyExpression) {
                Iterator<PyCallableParameter> parameter = mappedParameters.get(seeker);
                lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                if (parameter == null) continue;
                PyParameterInfoHandler.highlightParameter(parameter, parameterHintToIndex, hintFlags, mustHighlight);
                continue;
            }
            if (PyCallExpressionHelper.isVariadicPositionalArgument(arg)) {
                for (PyCallableParameter parameter : mapping.getParametersMappedToVariadicPositionalArguments()) {
                    lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                    PyParameterInfoHandler.highlightParameter(parameter, parameterHintToIndex, hintFlags, mustHighlight);
                }
                continue;
            }
            if (PyCallExpressionHelper.isVariadicKeywordArgument(arg)) {
                for (PyCallableParameter parameter : mapping.getParametersMappedToVariadicKeywordArguments()) {
                    lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                    PyParameterInfoHandler.highlightParameter(parameter, parameterHintToIndex, hintFlags, mustHighlight);
                }
                continue;
            }
            PyTupleParameter tupleParameter = Optional.ofNullable(mappedTupleParameters.get(arg)).map(PyCallableParameter::getParameter).map(psi -> PyUtil.as(psi, PyTupleParameter.class)).orElse(null);
            if (tupleParameter == null) continue;
            for (PyCallableParameter parameter : PyParameterInfoHandler.getFlattenedTupleParameterComponents(tupleParameter)) {
                lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                PyParameterInfoHandler.highlightParameter(parameter, parameterHintToIndex, hintFlags, mustHighlight);
            }
        }
        return lastParamIndex;
    }

    @NotNull
    private static List<PyCallableParameter> getFlattenedTupleParameterComponents(@NotNull PyTupleParameter parameter) {
        if (parameter == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(20);
        }
        ArrayList<PyCallableParameter> results = new ArrayList<PyCallableParameter>();
        for (PyParameter component : parameter.getContents()) {
            if (component instanceof PyNamedParameter) {
                results.add(PyCallableParameterImpl.psi(component));
                continue;
            }
            if (!(component instanceof PyTupleParameter)) continue;
            results.addAll(PyParameterInfoHandler.getFlattenedTupleParameterComponents((PyTupleParameter)component));
        }
        ArrayList<PyCallableParameter> arrayList = results;
        if (arrayList == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static void highlightParameter(@NotNull PyCallableParameter parameter, @NotNull Map<PyCallableParameter, Integer> parameterToHintIndex, @NotNull Map<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags, boolean mustHighlight) {
        if (parameter == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(22);
        }
        if (parameterToHintIndex == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(23);
        }
        if (hintFlags == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(24);
        }
        Integer hintIndex = parameterToHintIndex.get(parameter);
        if (mustHighlight && hintIndex != null && hintFlags.containsKey(hintIndex)) {
            hintFlags.get(hintIndex).add(ParameterInfoUIContextEx.Flag.HIGHLIGHT);
        }
    }

    private static List<String> buildParameterListHint(@NotNull List<PyCallableParameter> parameters2, final @NotNull Map<Integer, PyCallableParameter> indexToNamedParameter, final @NotNull Map<PyCallableParameter, Integer> parameterToHintIndex, final @NotNull Map<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags, final @NotNull TypeEvalContext context) {
        if (parameters2 == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(25);
        }
        if (indexToNamedParameter == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(26);
        }
        if (parameterToHintIndex == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(27);
        }
        if (hintFlags == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(28);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(29);
        }
        final ArrayList<String> hintsList = new ArrayList<String>();
        final int[] currentParameterIndex = new int[]{0};
        ParamHelper.walkDownParameters(parameters2, new ParamHelper.ParamWalker(){

            @Override
            public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                hintFlags.put(hintsList.size(), EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class));
                hintsList.add("(");
            }

            @Override
            public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                hintFlags.put(hintsList.size(), EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class));
                hintsList.add(last ? ")" : "), ");
            }

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                this.visitNonPsiParameter(PyCallableParameterImpl.psi(param), first, last);
            }

            @Override
            public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
                hintFlags.put(hintsList.size(), EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class));
                hintsList.add(last ? "*" : "*, ");
                currentParameterIndex[0] = currentParameterIndex[0] + 1;
            }

            @Override
            public void visitNonPsiParameter(@NotNull PyCallableParameter parameter, boolean first, boolean last) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(0);
                }
                indexToNamedParameter.put(currentParameterIndex[0], parameter);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(parameter.getPresentableText(true, context, type -> type == null || type instanceof PyStructuralType));
                if (!last) {
                    stringBuilder.append(", ");
                }
                int hintIndex = hintsList.size();
                parameterToHintIndex.put(parameter, hintIndex);
                hintFlags.put(hintIndex, EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class));
                hintsList.add(stringBuilder.toString());
                currentParameterIndex[0] = currentParameterIndex[0] + 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/PyParameterInfoHandler$1", "visitNonPsiParameter"));
            }
        });
        return hintsList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyParameterInfoHandler";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callAndCallee";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marked";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexToNamedParameter";
                break;
            }
            case 13: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterToHintIndex";
                break;
            }
            case 14: 
            case 18: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintFlags";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterHintToIndex";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatArgs";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersForLookup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyParameterInfoHandler";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlattenedTupleParameterComponents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findArgumentList";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "highlightNext";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFlattenedTupleParameterComponents";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "highlightParameter";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterListHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

