/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.highlighting.PyHighlighter;

class PyConsoleSourceHighlighter {
    private final Lexer myLexer;
    private final EditorColorsScheme myScheme;
    private final PyHighlighter myPyHighlighter;
    private int myLexerState;
    private final PythonConsoleView myPythonConsoleView;

    PyConsoleSourceHighlighter(PythonConsoleView pythonConsoleView, EditorColorsScheme scheme2, PyHighlighter pyHighlighter) {
        this.myPythonConsoleView = pythonConsoleView;
        this.myScheme = scheme2;
        this.myPyHighlighter = pyHighlighter;
        this.myLexer = this.myPyHighlighter.getHighlightingLexer();
    }

    public void printHighlightedSource(String text2) {
        this.myLexer.start((CharSequence)text2, 0, text2.length(), this.getLexerState());
        while (this.hasNext()) {
            Pair<String, ConsoleViewContentType> pair = this.next();
            this.myPythonConsoleView.printText((String)pair.first, (ConsoleViewContentType)pair.second);
        }
    }

    private boolean hasNext() {
        return this.myLexer.getTokenType() != null;
    }

    private Pair<String, ConsoleViewContentType> next() {
        this.myLexerState = this.myLexer.getState();
        IElementType tokenType = this.myLexer.getTokenType();
        Pair res = Pair.create((Object)this.myLexer.getTokenText(), (Object)(tokenType == null ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewUtil.getContentTypeForToken(tokenType, (SyntaxHighlighter)this.myPyHighlighter)));
        this.myLexer.advance();
        return res;
    }

    private int getLexerState() {
        return this.myLexerState != 1024 ? this.myLexerState : 0;
    }

    protected TextAttributes convertAttributes(TextAttributesKey[] keys) {
        EditorColorsScheme scheme2 = this.myScheme;
        TextAttributes attrs = scheme2.getAttributes(HighlighterColors.TEXT);
        for (TextAttributesKey key : keys) {
            TextAttributes attrs2 = scheme2.getAttributes(key);
            if (attrs2 == null) continue;
            attrs = TextAttributes.merge((TextAttributes)attrs, (TextAttributes)attrs2);
        }
        return attrs;
    }
}

