/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringFormatParser {
    private static final Pattern NEW_STYLE_FORMAT_TOKENS = Pattern.compile("(\\{\\{)|(\\}\\})|(\\{[^\\{\\}]*\\})|([^\\{\\}]+)");
    @NotNull
    private final String myLiteral;
    @NotNull
    private final List<FormatStringChunk> myResult;
    private int myPos;
    private int mySubstitutionsCount;
    private static final String CONVERSION_FLAGS = "#0- +";
    private static final String DIGITS = "0123456789";
    private static final String LENGTH_MODIFIERS = "hlL";
    private static final String VALID_CONVERSION_TYPES = "diouxXeEfFgGcrsba";
    private static final String ALIGN_SYMBOLS = "<>=^";
    private static final String SIGN_SYMBOLS = "+- ";
    private static final String CONVERSIONS = "rsa";
    private static final char ALTERNATE_FORM_SYMBOL = '#';
    private static final char ZERO_PADDING_SYMBOL = '0';

    public PyStringFormatParser(@NotNull String literal) {
        if (literal == null) {
            PyStringFormatParser.$$$reportNull$$$0(0);
        }
        this.myResult = new ArrayList<FormatStringChunk>();
        this.mySubstitutionsCount = 0;
        this.myLiteral = literal;
    }

    @NotNull
    public static List<FormatStringChunk> parsePercentFormat(@NotNull String s) {
        if (s == null) {
            PyStringFormatParser.$$$reportNull$$$0(1);
        }
        List<FormatStringChunk> list2 = new PyStringFormatParser(s).parse();
        if (list2 == null) {
            PyStringFormatParser.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static List<FormatStringChunk> parseNewStyleFormat(@NotNull String s) {
        if (s == null) {
            PyStringFormatParser.$$$reportNull$$$0(3);
        }
        List<FormatStringChunk> list2 = new PyStringFormatParser(s).parseNewStyle();
        if (list2 == null) {
            PyStringFormatParser.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    private List<FormatStringChunk> parse() {
        this.myPos = 0;
        while (this.myPos < this.myLiteral.length()) {
            int next = this.myLiteral.indexOf(37, this.myPos);
            while (next >= 0 && next < this.myLiteral.length() - 1 && this.myLiteral.charAt(next + 1) == '%') {
                next = this.myLiteral.indexOf(37, next + 2);
            }
            if (next < 0) break;
            if (next > this.myPos) {
                this.myResult.add(new ConstantChunk(this.myPos, next));
            }
            this.myPos = next;
            this.parseSubstitution();
        }
        if (this.myPos < this.myLiteral.length()) {
            this.myResult.add(new ConstantChunk(this.myPos, this.myLiteral.length()));
        }
        List<FormatStringChunk> list2 = this.myResult;
        if (list2 == null) {
            PyStringFormatParser.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public List<FormatStringChunk> parseNewStyle() {
        ArrayList<FormatStringChunk> results = new ArrayList<FormatStringChunk>();
        Matcher matcher = NEW_STYLE_FORMAT_TOKENS.matcher(this.myLiteral);
        int autoPositionedFieldsCount = 0;
        boolean skipNext = false;
        while (matcher.find()) {
            String group = matcher.group();
            this.myPos = matcher.start();
            int end = matcher.end();
            if (group.endsWith("\\N")) {
                skipNext = true;
                continue;
            }
            if ("{{".equals(group) || "}}".equals(group)) {
                results.add(new ConstantChunk(this.myPos, end));
                continue;
            }
            if (group.startsWith("{") && group.endsWith("}")) {
                if (!skipNext) {
                    autoPositionedFieldsCount = this.parseNewStyleSubstitution(results, end, autoPositionedFieldsCount);
                }
                skipNext = false;
                continue;
            }
            results.add(new ConstantChunk(this.myPos, end));
        }
        return results;
    }

    private int parseNewStyleSubstitution(List<FormatStringChunk> results, int end, int autoPositionedFieldsCount) {
        String conversion;
        NewStyleSubstitutionChunk chunk = new NewStyleSubstitutionChunk(this.myPos);
        chunk.setEndIndex(end);
        ++this.myPos;
        int nameEnd = StringUtil.indexOfAny((String)this.myLiteral, (String)"!:.[}", (int)this.myPos, (int)end);
        if (nameEnd > 0 && this.myPos < nameEnd) {
            String name = this.myLiteral.substring(this.myPos, nameEnd);
            try {
                int number = Integer.parseInt(name);
                chunk.setManualPosition(number);
            }
            catch (NumberFormatException e) {
                chunk.setMappingKey(name);
            }
            this.myPos = nameEnd;
        } else {
            chunk.setAutoPosition(autoPositionedFieldsCount);
            ++autoPositionedFieldsCount;
        }
        if (this.isAt('.')) {
            ++this.myPos;
            int attributeEnd = StringUtil.indexOfAny((String)this.myLiteral, (String)"!:.[}", (int)this.myPos, (int)end);
            if (attributeEnd > 0 && this.myPos < attributeEnd) {
                String attributeName = this.myLiteral.substring(this.myPos, attributeEnd);
                chunk.setMappingKeyAttributeName(attributeName);
                this.myPos = attributeEnd;
            }
        }
        if (this.isAt('[')) {
            ++this.myPos;
            int indexElementEnd = StringUtil.indexOfAny((String)this.myLiteral, (String)"!:.]", (int)this.myPos, (int)end);
            if (indexElementEnd > 0 && this.myPos < indexElementEnd) {
                String index = this.myLiteral.substring(this.myPos, indexElementEnd);
                chunk.setMappingKeyElementIndex(index);
                this.myPos = indexElementEnd + 1;
            }
        }
        while (this.isAt('.') || this.isAt('[')) {
            int attributeEnd;
            if (this.isAt('.')) {
                ++this.myPos;
                attributeEnd = StringUtil.indexOfAny((String)this.myLiteral, (String)"!:.[", (int)this.myPos, (int)end);
                if (attributeEnd <= 0 || this.myPos >= attributeEnd) continue;
                this.myPos = attributeEnd;
                continue;
            }
            ++this.myPos;
            attributeEnd = StringUtil.indexOf((CharSequence)this.myLiteral, (char)']', (int)this.myPos, (int)end);
            if (attributeEnd <= 0 || this.myPos >= attributeEnd) continue;
            this.myPos = attributeEnd + 1;
        }
        this.myPos = Math.max(this.myPos, StringUtil.indexOf((CharSequence)this.myLiteral, (char)'!', (int)this.myPos, (int)end) + 1);
        int conversionEnd = StringUtil.indexOfAny((String)this.myLiteral, (String)":}", (int)this.myPos, (int)end);
        if (conversionEnd - this.myPos == 1 && StringUtil.containsAnyChar((String)(conversion = this.myLiteral.substring(this.myPos, conversionEnd)), (String)CONVERSIONS)) {
            chunk.setConversion(conversion);
            this.myPos = conversionEnd;
        }
        if (this.isAt(':')) {
            ++this.myPos;
            this.myPos = Math.max(this.myPos, StringUtil.indexOfAny((String)this.myLiteral, (String)ALIGN_SYMBOLS, (int)this.myPos, (int)end) + 1);
            if (this.isAtSet(SIGN_SYMBOLS)) {
                chunk.setSignOption();
                ++this.myPos;
            }
            if (this.isAt('#')) {
                chunk.setAlternateForm();
                ++this.myPos;
            }
            if (this.isAt('0')) {
                chunk.setZeroPadding();
                ++this.myPos;
            }
            chunk.setWidth(this.parseWhileCharacterInSet(DIGITS));
            if (this.isAt(',')) {
                ++this.myPos;
                chunk.setThousandsSeparator();
            }
            if (this.isAt('.')) {
                ++this.myPos;
                chunk.setPrecision(this.parseWhileCharacterInSet(DIGITS));
            }
            if (this.myPos < end - 1) {
                chunk.setConversionType(this.myLiteral.charAt(this.myPos));
            }
        }
        results.add(chunk);
        return autoPositionedFieldsCount;
    }

    private void parseSubstitution() {
        assert (this.myLiteral.charAt(this.myPos) == '%');
        PercentSubstitutionChunk chunk = new PercentSubstitutionChunk(this.myPos);
        this.myResult.add(chunk);
        ++this.myPos;
        if (this.isAt('(')) {
            int mappingEnd = this.myLiteral.indexOf(41, this.myPos + 1);
            if (mappingEnd < 0) {
                chunk.setEndIndex(this.myLiteral.length());
                chunk.setMappingKey(this.myLiteral.substring(this.myPos + 1));
                chunk.setUnclosedMapping();
                this.myPos = this.myLiteral.length();
                return;
            }
            chunk.setMappingKey(this.myLiteral.substring(this.myPos + 1, mappingEnd));
            this.myPos = mappingEnd + 1;
        } else {
            chunk.setAutoPosition(this.mySubstitutionsCount);
            ++this.mySubstitutionsCount;
        }
        chunk.setConversionFlags(this.parseWhileCharacterInSet(CONVERSION_FLAGS));
        chunk.setWidth(this.parseWidth());
        if (this.isAt('.')) {
            ++this.myPos;
            chunk.setPrecision(this.parseWidth());
        }
        if (this.isAtSet(LENGTH_MODIFIERS)) {
            chunk.setLengthModifier(this.myLiteral.charAt(this.myPos));
            ++this.myPos;
        }
        if (this.isAtSet(VALID_CONVERSION_TYPES)) {
            chunk.setConversionType(this.myLiteral.charAt(this.myPos));
            ++this.myPos;
        }
        chunk.setEndIndex(this.myPos);
    }

    private boolean isAtSet(@NotNull String characterSet) {
        if (characterSet == null) {
            PyStringFormatParser.$$$reportNull$$$0(6);
        }
        return this.myPos < this.myLiteral.length() && characterSet.indexOf(this.myLiteral.charAt(this.myPos)) >= 0;
    }

    private boolean isAt(char c) {
        return this.myPos < this.myLiteral.length() && this.myLiteral.charAt(this.myPos) == c;
    }

    @NotNull
    private String parseWidth() {
        if (this.isAt('*')) {
            ++this.myPos;
            if ("*" == null) {
                PyStringFormatParser.$$$reportNull$$$0(7);
            }
            return "*";
        }
        String string = this.parseWhileCharacterInSet(DIGITS);
        if (string == null) {
            PyStringFormatParser.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private String parseWhileCharacterInSet(@NotNull String characterSet) {
        if (characterSet == null) {
            PyStringFormatParser.$$$reportNull$$$0(9);
        }
        int flagStart = this.myPos;
        while (this.isAtSet(characterSet)) {
            ++this.myPos;
        }
        String string = this.myLiteral.substring(flagStart, this.myPos);
        if (string == null) {
            PyStringFormatParser.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static List<SubstitutionChunk> filterSubstitutions(@NotNull List<FormatStringChunk> chunks) {
        if (chunks == null) {
            PyStringFormatParser.$$$reportNull$$$0(11);
        }
        ArrayList<SubstitutionChunk> results = new ArrayList<SubstitutionChunk>();
        for (FormatStringChunk chunk : chunks) {
            if (!(chunk instanceof SubstitutionChunk)) continue;
            results.add((SubstitutionChunk)chunk);
        }
        ArrayList<SubstitutionChunk> arrayList = results;
        if (arrayList == null) {
            PyStringFormatParser.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public static List<SubstitutionChunk> getPositionalSubstitutions(@NotNull List<SubstitutionChunk> substitutions) {
        if (substitutions == null) {
            PyStringFormatParser.$$$reportNull$$$0(13);
        }
        ArrayList<SubstitutionChunk> result2 = new ArrayList<SubstitutionChunk>();
        for (SubstitutionChunk s : substitutions) {
            if (s.getMappingKey() != null) continue;
            result2.add(s);
        }
        ArrayList<SubstitutionChunk> arrayList = result2;
        if (arrayList == null) {
            PyStringFormatParser.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, SubstitutionChunk> getKeywordSubstitutions(@NotNull List<SubstitutionChunk> substitutions) {
        if (substitutions == null) {
            PyStringFormatParser.$$$reportNull$$$0(15);
        }
        HashMap<String, SubstitutionChunk> result2 = new HashMap<String, SubstitutionChunk>();
        for (SubstitutionChunk s : substitutions) {
            String key = s.getMappingKey();
            if (key == null) continue;
            result2.put(key, s);
        }
        HashMap<String, SubstitutionChunk> hashMap = result2;
        if (hashMap == null) {
            PyStringFormatParser.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @NotNull
    public static List<TextRange> substitutionsToRanges(@NotNull List<SubstitutionChunk> substitutions) {
        if (substitutions == null) {
            PyStringFormatParser.$$$reportNull$$$0(17);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        for (SubstitutionChunk substitution : substitutions) {
            ranges.add(TextRange.create((int)substitution.getStartIndex(), (int)substitution.getEndIndex()));
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            PyStringFormatParser.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Nullable
    public static PyExpression getFormatValueExpression(@NotNull PyStringLiteralExpression element) {
        PyBinaryExpression binaryExpr;
        PsiElement parent;
        if (element == null) {
            PyStringFormatParser.$$$reportNull$$$0(19);
        }
        if ((parent = element.getParent()) instanceof PyBinaryExpression && (binaryExpr = (PyBinaryExpression)parent).isOperator("%")) {
            PyExpression expr = binaryExpr.getRightExpression();
            while (expr instanceof PyParenthesizedExpression) {
                expr = ((PyParenthesizedExpression)expr).getContainedExpression();
            }
            return expr;
        }
        return null;
    }

    @Nullable
    public static PyArgumentList getNewStyleFormatValueExpression(@NotNull PyStringLiteralExpression element) {
        PsiElement parent2;
        PyQualifiedExpression qualifiedExpr;
        String name;
        PsiElement parent;
        if (element == null) {
            PyStringFormatParser.$$$reportNull$$$0(20);
        }
        if ((parent = element.getParent()) instanceof PyQualifiedExpression && "format".equals(name = (qualifiedExpr = (PyQualifiedExpression)parent).getReferencedName()) && (parent2 = qualifiedExpr.getParent()) instanceof PyCallExpression) {
            PyCallExpression callExpr = (PyCallExpression)parent2;
            return callExpr.getArgumentList();
        }
        return null;
    }

    @NotNull
    public static List<TextRange> getEscapeRanges(@NotNull String s) {
        if (s == null) {
            PyStringFormatParser.$$$reportNull$$$0(21);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        Matcher matcher = PyStringLiteralExpressionImpl.PATTERN_ESCAPE.matcher(s);
        while (matcher.find()) {
            ranges.add(TextRange.create((int)matcher.start(), (int)matcher.end()));
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            PyStringFormatParser.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyStringFormatParser";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "characterSet";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePercentFormat";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNewStyleFormat";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWidth";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWhileCharacterInSet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSubstitutions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionalSubstitutions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordSubstitutions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "substitutionsToRanges";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapeRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parsePercentFormat";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseNewStyleFormat";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAtSet";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseWhileCharacterInSet";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterSubstitutions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPositionalSubstitutions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordSubstitutions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "substitutionsToRanges";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFormatValueExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNewStyleFormatValueExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEscapeRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NewStyleSubstitutionChunk
    extends SubstitutionChunk {
        @Nullable
        private String myConversion;
        @Nullable
        private String myMappingKeyAttributeName;
        @Nullable
        private String myMappingKeyElementIndex;
        private boolean signOption;
        private boolean zeroPadding;
        private boolean alternateForm;
        private boolean thousandsSeparator;

        public NewStyleSubstitutionChunk(int startIndex) {
            super(startIndex, startIndex);
        }

        @Nullable
        public String getConversion() {
            return this.myConversion;
        }

        public void setConversion(@Nullable String conversion) {
            this.myConversion = conversion;
        }

        public boolean hasSignOption() {
            return this.signOption;
        }

        public void setSignOption() {
            this.signOption = true;
        }

        public boolean useAlternateForm() {
            return this.alternateForm;
        }

        public void setAlternateForm() {
            this.alternateForm = true;
        }

        public boolean hasZeroPadding() {
            return this.zeroPadding;
        }

        public void setZeroPadding() {
            this.zeroPadding = true;
        }

        public boolean hasThousandsSeparator() {
            return this.thousandsSeparator;
        }

        public void setThousandsSeparator() {
            this.thousandsSeparator = true;
        }

        @Nullable
        public String getMappingKeyAttributeName() {
            return this.myMappingKeyAttributeName;
        }

        public void setMappingKeyAttributeName(@NotNull String mappingKeyAttributeName) {
            if (mappingKeyAttributeName == null) {
                NewStyleSubstitutionChunk.$$$reportNull$$$0(0);
            }
            this.myMappingKeyAttributeName = mappingKeyAttributeName;
        }

        @Nullable
        public String getMappingKeyElementIndex() {
            return this.myMappingKeyElementIndex;
        }

        public void setMappingKeyElementIndex(@Nullable String mappingKeyElementIndex) {
            this.myMappingKeyElementIndex = mappingKeyElementIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappingKeyAttributeName", "com/jetbrains/python/inspections/PyStringFormatParser$NewStyleSubstitutionChunk", "setMappingKeyAttributeName"));
        }
    }

    public static class PercentSubstitutionChunk
    extends SubstitutionChunk {
        @Nullable
        private String myConversionFlags;
        private char myLengthModifier;
        private boolean myUnclosedMapping;

        public PercentSubstitutionChunk(int startIndex) {
            super(startIndex, startIndex);
        }

        @Nullable
        public String getConversionFlags() {
            return this.myConversionFlags;
        }

        private void setConversionFlags(@Nullable String conversionFlags) {
            this.myConversionFlags = conversionFlags;
        }

        public char getLengthModifier() {
            return this.myLengthModifier;
        }

        private void setLengthModifier(char lengthModifier) {
            this.myLengthModifier = lengthModifier;
        }

        public boolean isUnclosedMapping() {
            return this.myUnclosedMapping;
        }

        private void setUnclosedMapping() {
            this.myUnclosedMapping = true;
        }
    }

    public static class SubstitutionChunk
    extends FormatStringChunk {
        @Nullable
        private String myMappingKey;
        @Nullable
        private String myWidth;
        @Nullable
        private String myPrecision;
        @Nullable
        private Integer myManualPosition;
        @Nullable
        private Integer myAutoPosition;
        private char myConversionType;

        public SubstitutionChunk(int startIndex, int endIndex) {
            super(startIndex, endIndex);
        }

        protected void setEndIndex(int endIndex) {
            this.myEndIndex = endIndex;
        }

        @Nullable
        public Integer getManualPosition() {
            return this.myManualPosition;
        }

        protected void setManualPosition(@Nullable Integer position) {
            this.myManualPosition = position;
        }

        @Nullable
        public Integer getAutoPosition() {
            return this.myAutoPosition;
        }

        protected void setAutoPosition(@Nullable Integer autoPosition) {
            this.myAutoPosition = autoPosition;
        }

        public char getConversionType() {
            return this.myConversionType;
        }

        public void setConversionType(char conversionType) {
            this.myConversionType = conversionType;
        }

        @Nullable
        public String getPrecision() {
            return this.myPrecision;
        }

        public void setPrecision(@Nullable String precision) {
            this.myPrecision = precision;
        }

        @Nullable
        public String getWidth() {
            return this.myWidth;
        }

        public void setWidth(@Nullable String width) {
            this.myWidth = width;
        }

        @Nullable
        public String getMappingKey() {
            return this.myMappingKey;
        }

        protected void setMappingKey(@Nullable String mappingKey) {
            this.myMappingKey = mappingKey;
        }

        @Nullable
        public Integer getPosition() {
            return (Integer)ObjectUtils.chooseNotNull((Object)this.myManualPosition, (Object)this.myAutoPosition);
        }
    }

    public static class ConstantChunk
    extends FormatStringChunk {
        public ConstantChunk(int startIndex, int endIndex) {
            super(startIndex, endIndex);
        }
    }

    public static abstract class FormatStringChunk {
        private final int myStartIndex;
        protected int myEndIndex;

        public FormatStringChunk(int startIndex, int endIndex) {
            this.myStartIndex = startIndex;
            this.myEndIndex = endIndex;
        }

        public int getStartIndex() {
            return this.myStartIndex;
        }

        public int getEndIndex() {
            return this.myEndIndex;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.create((int)this.myStartIndex, (int)this.myEndIndex);
            if (textRange == null) {
                FormatStringChunk.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser$FormatStringChunk", "getTextRange"));
        }
    }
}

