/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class PyParser
implements PsiParser {
    private static final Logger LOGGER = Logger.getInstance((String)PyParser.class.getName());
    protected LanguageLevel myLanguageLevel = LanguageLevel.getDefault();
    private StatementParsing.FUTURE myFutureFlag;

    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder2) {
        long start = System.currentTimeMillis();
        PsiBuilder.Marker rootMarker = builder2.mark();
        ParsingContext context = this.createParsingContext(builder2, this.myLanguageLevel, this.myFutureFlag);
        StatementParsing statementParser = context.getStatementParser();
        builder2.setTokenTypeRemapper((ITokenTypeRemapper)statementParser);
        boolean lastAfterSemicolon = false;
        while (!builder2.eof()) {
            context.pushScope(context.emptyParsingScope());
            if (lastAfterSemicolon) {
                statementParser.parseSimpleStatement();
            } else {
                statementParser.parseStatement();
            }
            lastAfterSemicolon = context.getScope().isAfterSemicolon();
            context.popScope();
        }
        rootMarker.done(root);
        ASTNode ast = builder2.getTreeBuilt();
        if (LOGGER.isDebugEnabled()) {
            long diff = System.currentTimeMillis() - start;
            double kb = (double)builder2.getCurrentOffset() / 1000.0;
            if (diff > 5L) {
                LOGGER.debug("Parsed " + String.format("%.1f", kb) + "K file in " + diff + "ms");
            }
        }
        ASTNode aSTNode = ast;
        if (aSTNode == null) {
            PyParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    protected ParsingContext createParsingContext(PsiBuilder builder2, LanguageLevel languageLevel, StatementParsing.FUTURE futureFlag) {
        return new ParsingContext(builder2, languageLevel, futureFlag);
    }

    public void setFutureFlag(StatementParsing.FUTURE future2) {
        this.myFutureFlag = future2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/parsing/PyParser", "parse"));
    }
}

