/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTupleType
extends PyClassTypeImpl
implements PyCollectionType {
    @NotNull
    private final List<PyType> myElementTypes;
    private final boolean myHomogeneous;

    @Nullable
    public static PyTupleType create(@NotNull PsiElement anchor2, @NotNull List<PyType> elementTypes) {
        PyClass tuple;
        if (anchor2 == null) {
            PyTupleType.$$$reportNull$$$0(0);
        }
        if (elementTypes == null) {
            PyTupleType.$$$reportNull$$$0(1);
        }
        if ((tuple = PyBuiltinCache.getInstance(anchor2).getClass("tuple")) != null) {
            return new PyTupleType(tuple, elementTypes, false);
        }
        return null;
    }

    @Nullable
    public static PyTupleType createHomogeneous(@NotNull PsiElement anchor2, @Nullable PyType elementType) {
        PyClass tuple;
        if (anchor2 == null) {
            PyTupleType.$$$reportNull$$$0(2);
        }
        if ((tuple = PyBuiltinCache.getInstance(anchor2).getClass("tuple")) != null) {
            return new PyTupleType(tuple, Collections.singletonList(elementType), true);
        }
        return null;
    }

    public PyTupleType(@NotNull PyClass tupleClass, @NotNull List<PyType> elementTypes, boolean homogeneous) {
        if (tupleClass == null) {
            PyTupleType.$$$reportNull$$$0(3);
        }
        if (elementTypes == null) {
            PyTupleType.$$$reportNull$$$0(4);
        }
        this(tupleClass, elementTypes, homogeneous, false);
    }

    protected PyTupleType(@NotNull PyClass tupleClass, @NotNull List<PyType> elementTypes, boolean homogeneous, boolean isDefinition) {
        if (tupleClass == null) {
            PyTupleType.$$$reportNull$$$0(5);
        }
        if (elementTypes == null) {
            PyTupleType.$$$reportNull$$$0(6);
        }
        super(tupleClass, isDefinition);
        this.myElementTypes = elementTypes;
        this.myHomogeneous = homogeneous;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myHomogeneous) {
            String string = "(" + PyTupleType.getTypeName(this.getIteratedItemType()) + ", ...)";
            if (string == null) {
                PyTupleType.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = "(" + StringUtil.join(this.myElementTypes, PyTupleType::getTypeName, (String)", ") + ")";
        if (string == null) {
            PyTupleType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static String getTypeName(@Nullable PyType type) {
        return type == null ? "Any" : type.getName();
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Nullable
    public PyType getElementType(int index) {
        if (this.myHomogeneous) {
            return this.getIteratedItemType();
        }
        if (index >= 0 && index < this.myElementTypes.size()) {
            return this.myElementTypes.get(index);
        }
        return null;
    }

    public int getElementCount() {
        return this.myHomogeneous ? -1 : this.myElementTypes.size();
    }

    public boolean isHomogeneous() {
        return this.myHomogeneous;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyTupleType that = (PyTupleType)o;
        return this.myElementTypes.equals(that.myElementTypes);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myElementTypes.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public List<PyType> getElementTypes() {
        List<PyType> list2 = this.myElementTypes;
        if (list2 == null) {
            PyTupleType.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    @Nullable
    public PyType getIteratedItemType() {
        return PyUnionType.union(this.myElementTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTupleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTupleType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHomogeneous";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

