/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonEnvUtil {
    public static final String PYTHONPATH = "PYTHONPATH";
    public static final String PYTHONUNBUFFERED = "PYTHONUNBUFFERED";
    public static final String PYTHONIOENCODING = "PYTHONIOENCODING";
    public static final String IPYTHONENABLE = "IPYTHONENABLE";
    public static final String PYTHONDONTWRITEBYTECODE = "PYTHONDONTWRITEBYTECODE";
    public static final String PYVENV_LAUNCHER = "__PYVENV_LAUNCHER__";

    private PythonEnvUtil() {
    }

    public static Map<String, String> setPythonUnbuffered(@NotNull Map<String, String> env) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(0);
        }
        env.put(PYTHONUNBUFFERED, "1");
        return env;
    }

    public static Map<String, String> setPythonIOEncoding(@NotNull Map<String, String> env, @NotNull String encoding) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(1);
        }
        if (encoding == null) {
            PythonEnvUtil.$$$reportNull$$$0(2);
        }
        env.put(PYTHONIOENCODING, encoding);
        return env;
    }

    public static Map<String, String> resetHomePathChanges(@NotNull String homePath, @NotNull Map<String, String> env) {
        if (homePath == null) {
            PythonEnvUtil.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(4);
        }
        if (System.getenv(PYVENV_LAUNCHER) != null || EnvironmentUtil.getEnvironmentMap().containsKey(PYVENV_LAUNCHER)) {
            env.put(PYVENV_LAUNCHER, homePath);
        }
        return env;
    }

    @NotNull
    public static String appendToPathEnvVar(@Nullable String source, @NotNull String value) {
        if (value == null) {
            PythonEnvUtil.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)source)) {
            String string = value;
            if (string == null) {
                PythonEnvUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        HashSet paths = Sets.newHashSet((Object[])source.split(File.pathSeparator));
        String string = !paths.contains(value) ? source + File.pathSeparator + value : source;
        if (string == null) {
            PythonEnvUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static void addPathsToEnv(@NotNull Map<String, String> env, String key, @NotNull Collection<String> values) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(8);
        }
        if (values == null) {
            PythonEnvUtil.$$$reportNull$$$0(9);
        }
        for (String val : values) {
            PythonEnvUtil.addPathToEnv(env, key, val);
        }
    }

    public static void addPathToEnv(@NotNull Map<String, String> env, String key, String value) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(10);
        }
        if (!StringUtil.isEmpty((String)value)) {
            if (env.containsKey(key)) {
                env.put(key, PythonEnvUtil.appendToPathEnvVar(env.get(key), value));
            } else {
                env.put(key, value);
            }
        }
    }

    public static void addToPythonPath(@NotNull Map<String, String> env, @NotNull Collection<String> values) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(11);
        }
        if (values == null) {
            PythonEnvUtil.$$$reportNull$$$0(12);
        }
        PythonEnvUtil.addPathsToEnv(env, PYTHONPATH, values);
    }

    public static void addToPythonPath(@NotNull Map<String, String> env, String value) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(13);
        }
        PythonEnvUtil.addPathToEnv(env, PYTHONPATH, value);
    }

    public static void mergePythonPath(@NotNull Map<String, String> from, @NotNull Map<String, String> to) {
        String value;
        if (from == null) {
            PythonEnvUtil.$$$reportNull$$$0(14);
        }
        if (to == null) {
            PythonEnvUtil.$$$reportNull$$$0(15);
        }
        if ((value = from.get(PYTHONPATH)) != null) {
            HashSet paths = Sets.newHashSet((Object[])value.split(File.pathSeparator));
            PythonEnvUtil.addToPythonPath(to, paths);
        }
    }

    @NotNull
    public static Map<String, String> setPythonDontWriteBytecode(@NotNull Map<String, String> env) {
        if (env == null) {
            PythonEnvUtil.$$$reportNull$$$0(16);
        }
        env.put(PYTHONDONTWRITEBYTECODE, "1");
        Map<String, String> map2 = env;
        if (map2 == null) {
            PythonEnvUtil.$$$reportNull$$$0(17);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonEnvUtil";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonEnvUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "appendToPathEnvVar";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setPythonDontWriteBytecode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPythonUnbuffered";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPythonIOEncoding";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetHomePathChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendToPathEnvVar";
                break;
            }
            case 6: 
            case 7: 
            case 17: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPathsToEnv";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPathToEnv";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addToPythonPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mergePythonPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setPythonDontWriteBytecode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

