/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.intellij.images.search.ImageTagManager;
import org.intellij.images.search.TagFilter;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilterByTagActionGroup
extends ActionGroup
implements PopupAction {
    public FilterByTagActionGroup() {
        this.setPopup(true);
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        ImageTagManager tagManager = ImageTagManager.getInstance(project);
        e.getPresentation().setVisible(view != null && !tagManager.getAllTags().isEmpty());
        Object[] filters = view != null ? view.getTagFilters() : null;
        e.getPresentation().setText(filters == null ? "All" : StringUtil.join((Object[])filters, filter -> filter.getDisplayName(), (String)","));
        e.getPresentation().setIcon(AllIcons.Duplicates.SendToTheRight);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                FilterByTagActionGroup.$$$reportNull$$$0(0);
            }
            return AnAction.EMPTY_ARRAY;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        Project project = e.getProject();
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        if (view == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                FilterByTagActionGroup.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ImageTagManager tagManager = ImageTagManager.getInstance(project);
        final List tagActions = tagManager.getAllTags().stream().map(tag -> new MyToggleAction(view, new TagFilter((String)tag, tagManager))).collect(Collectors.toList());
        group.add(new AnAction("All"){

            public void actionPerformed(AnActionEvent e) {
                for (MyToggleAction tagAction : tagActions) {
                    tagAction.setSelected(e, false);
                }
            }
        });
        group.add((AnAction)Separator.getInstance());
        group.addAll(tagActions);
        AnAction[] anActionArray = group.getChildren(e);
        if (anActionArray == null) {
            FilterByTagActionGroup.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/FilterByTagActionGroup", "getChildren"));
    }

    private static class MyToggleAction
    extends ToggleAction {
        private final ThumbnailView myView;
        private final TagFilter myFilter;

        public MyToggleAction(ThumbnailView view, TagFilter filter) {
            super(filter.getDisplayName());
            this.myView = view;
            this.myFilter = filter;
        }

        public boolean isSelected(AnActionEvent e) {
            TagFilter[] filters = this.myView.getTagFilters();
            return filters != null && Arrays.stream(filters).anyMatch(f -> this.myFilter.getDisplayName().equals(f.getDisplayName()));
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            if (state2) {
                this.myFilter.setFilter(this.myView);
            } else {
                this.myFilter.clearFilter(this.myView);
            }
        }
    }
}

