/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CancellableContinuation;
import kotlinx.coroutines.experimental.CoroutineDispatcher;
import kotlinx.coroutines.experimental.DefaultExecutor;
import kotlinx.coroutines.experimental.Delay;
import kotlinx.coroutines.experimental.DisposableFutureHandle;
import kotlinx.coroutines.experimental.DisposableHandle;
import kotlinx.coroutines.experimental.JobKt;
import kotlinx.coroutines.experimental.ResumeUndispatchedRunnable;
import kotlinx.coroutines.experimental.TimeSourceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J&\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lkotlinx/coroutines/experimental/ExecutorCoroutineDispatcherBase;", "Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "Lkotlinx/coroutines/experimental/Delay;", "()V", "executor", "Ljava/util/concurrent/Executor;", "getExecutor$kotlinx_coroutines_core", "()Ljava/util/concurrent/Executor;", "dispatch", "", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/experimental/Runnable;", "equals", "", "other", "", "hashCode", "", "invokeOnTimeout", "Lkotlinx/coroutines/experimental/DisposableHandle;", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "scheduleResumeAfterDelay", "continuation", "Lkotlinx/coroutines/experimental/CancellableContinuation;", "toString", "", "kotlinx-coroutines-core"})
public abstract class ExecutorCoroutineDispatcherBase
extends CoroutineDispatcher
implements Delay {
    @NotNull
    public abstract Executor getExecutor$kotlinx_coroutines_core();

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        try {
            this.getExecutor$kotlinx_coroutines_core().execute(TimeSourceKt.getTimeSource().trackTask(block));
        }
        catch (RejectedExecutionException e) {
            TimeSourceKt.getTimeSource().unTrackTask();
            DefaultExecutor.INSTANCE.execute$kotlinx_coroutines_core(block);
        }
    }

    @Override
    public void scheduleResumeAfterDelay(long time, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
        try {
            Executor executor2 = this.getExecutor$kotlinx_coroutines_core();
            if (!(executor2 instanceof ScheduledExecutorService)) {
                executor2 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor2;
            scheduledFuture = scheduledExecutorService != null ? scheduledExecutorService.schedule(new ResumeUndispatchedRunnable(this, continuation), time, unit) : null;
        }
        catch (RejectedExecutionException e) {
            scheduledFuture = null;
        }
        ScheduledFuture<?> timeout = scheduledFuture;
        if (timeout != null) {
            JobKt.cancelFutureOnCompletion(continuation, (Future)timeout);
        } else {
            DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(time, unit, continuation);
        }
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long time, @NotNull TimeUnit unit, @NotNull Runnable block) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        try {
            Executor executor2 = this.getExecutor$kotlinx_coroutines_core();
            if (!(executor2 instanceof ScheduledExecutorService)) {
                executor2 = null;
            }
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor2;
            scheduledFuture = scheduledExecutorService != null ? scheduledExecutorService.schedule(block, time, unit) : null;
        }
        catch (RejectedExecutionException e) {
            scheduledFuture = null;
        }
        ScheduledFuture<?> timeout = scheduledFuture;
        if (timeout != null) {
            return new DisposableFutureHandle((Future)timeout);
        }
        return DefaultExecutor.INSTANCE.invokeOnTimeout(time, unit, block);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getExecutor$kotlinx_coroutines_core().toString();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ExecutorCoroutineDispatcherBase && ((ExecutorCoroutineDispatcherBase)other).getExecutor$kotlinx_coroutines_core() == this.getExecutor$kotlinx_coroutines_core();
    }

    public int hashCode() {
        return System.identityHashCode(this.getExecutor$kotlinx_coroutines_core());
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> continuation) {
        return Delay.DefaultImpls.delay(this, time, unit, continuation);
    }
}

