/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorate;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileMargedVertically
extends FtileDecorate {
    private final double margin1;
    private final double margin2;

    public FtileMargedVertically(Ftile tile, double margin1, double margin2) {
        super(tile);
        this.margin1 = margin1;
        this.margin2 = margin2;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.margin1 > 0.0) {
            ug = ug.apply(new UTranslate(0.0, this.margin1));
        }
        ug.draw(this.getFtileDelegated());
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry orig = this.getFtileDelegated().calculateDimension(stringBounder);
        return new FtileGeometry(orig.getWidth(), orig.getHeight() + this.margin1 + this.margin2, orig.getLeft(), orig.getInY() + this.margin1, orig.hasPointOut() ? orig.getOutY() + this.margin1 : orig.getOutY());
    }
}

