/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import net.sourceforge.plantuml.code.URLEncoder;

public class AsciiEncoder
implements URLEncoder {
    private final char[] encode6bit = new char[64];
    private final byte[] decode6bit = new byte[128];

    public AsciiEncoder() {
        for (byte b = 0; b < 64; b = (byte)(b + 1)) {
            this.encode6bit[b] = this.encode6bit(b);
            this.decode6bit[this.encode6bit[b]] = b;
        }
    }

    @Override
    public String encode(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuilder resu = new StringBuilder((data.length * 4 + 2) / 3);
        for (int i = 0; i < data.length; i += 3) {
            this.append3bytes(resu, data[i] & 0xFF, i + 1 < data.length ? data[i + 1] & 0xFF : 0, i + 2 < data.length ? data[i + 2] & 0xFF : 0);
        }
        return resu.toString();
    }

    @Override
    public byte[] decode(String s) {
        if (s.length() % 4 != 0) {
            throw new IllegalArgumentException("Cannot decode " + s);
        }
        byte[] data = new byte[(s.length() * 3 + 3) / 4];
        int pos = 0;
        for (int i = 0; i < s.length(); i += 4) {
            this.decode3bytes(data, pos, s.charAt(i), s.charAt(i + 1), s.charAt(i + 2), s.charAt(i + 3));
            pos += 3;
        }
        return data;
    }

    public int decode6bit(char c) {
        return this.decode6bit[c];
    }

    public char encode6bit(byte b) {
        assert (b >= 0 && b < 64);
        if (b < 10) {
            return (char)(48 + b);
        }
        if ((b = (byte)(b - 10)) < 26) {
            return (char)(65 + b);
        }
        if ((b = (byte)(b - 26)) < 26) {
            return (char)(97 + b);
        }
        if ((b = (byte)(b - 26)) == 0) {
            return '-';
        }
        if (b == 1) {
            return '_';
        }
        assert (false);
        return '?';
    }

    private void append3bytes(StringBuilder sb, int b1, int b2, int b3) {
        int c1 = b1 >> 2;
        int c2 = (b1 & 3) << 4 | b2 >> 4;
        int c3 = (b2 & 0xF) << 2 | b3 >> 6;
        int c4 = b3 & 0x3F;
        sb.append(this.encode6bit[c1 & 0x3F]);
        sb.append(this.encode6bit[c2 & 0x3F]);
        sb.append(this.encode6bit[c3 & 0x3F]);
        sb.append(this.encode6bit[c4 & 0x3F]);
    }

    private void decode3bytes(byte[] r, int pos, char cc1, char cc2, char cc3, char cc4) {
        byte c1 = this.decode6bit[cc1];
        byte c2 = this.decode6bit[cc2];
        byte c3 = this.decode6bit[cc3];
        byte c4 = this.decode6bit[cc4];
        r[pos] = (byte)(c1 << 2 | c2 >> 4);
        r[pos + 1] = (byte)((c2 & 0xF) << 4 | c3 >> 2);
        r[pos + 2] = (byte)((c3 & 3) << 6 | c4);
    }
}

