/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.core.Diagram;

public abstract class SingleLineCommand<S extends Diagram>
implements Command<S> {
    private final Pattern2 pattern;

    public SingleLineCommand(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        if (!pattern.startsWith("(?i)^") || !pattern.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + pattern);
        }
        this.pattern = MyPattern.cmpile(pattern);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.pattern()};
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (lines.size() != 1) {
            return CommandControl.NOT_OK;
        }
        lines = lines.removeInnerComments();
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        String line = StringUtils.trin(lines.getFirst499());
        Matcher2 m = this.pattern.matcher(line);
        boolean result = m.find();
        if (result) {
            this.actionIfCommandValid();
        }
        return result ? CommandControl.OK : CommandControl.NOT_OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines) {
        if (lines.size() != 1) {
            throw new IllegalArgumentException();
        }
        String line = StringUtils.trin((lines = lines.removeInnerComments()).getFirst499());
        if (this.isForbidden(line)) {
            return CommandExecutionResult.error("Syntax error: " + line);
        }
        List<String> arg = this.getSplit(line);
        if (arg == null) {
            return CommandExecutionResult.error("Cannot parse line " + line);
        }
        return this.executeArg(system, arg);
    }

    protected boolean isForbidden(String line) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(S var1, List<String> var2);

    public final List<String> getSplit(String line) {
        return StringUtils.getSplit(this.pattern, line);
    }
}

