/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockBordered
extends AbstractTextBlock
implements TextBlock {
    private final double cornersize;
    private final HtmlColor backgroundColor;
    private final HtmlColor borderColor;
    private final int marginX = 6;
    private final int marginY = 5;
    private final UStroke stroke;
    private final boolean withShadow;
    private final TextBlock textBlock;

    TextBlockBordered(TextBlock textBlock, UStroke stroke, HtmlColor borderColor, HtmlColor backgroundColor, double cornersize) {
        this.cornersize = cornersize;
        this.textBlock = textBlock;
        this.withShadow = false;
        this.stroke = stroke;
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
    }

    private double getTextHeight(StringBounder stringBounder) {
        Dimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getHeight() + 10.0;
    }

    private double getPureTextWidth(StringBounder stringBounder) {
        Dimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getWidth();
    }

    private double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 12.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getTextHeight(stringBounder);
        double width = this.getTextWidth(stringBounder);
        return new Dimension2DDouble(width + 1.0, height + 1.0);
    }

    private UGraphic applyStroke(UGraphic ug) {
        if (this.stroke == null) {
            return ug;
        }
        return ug.apply(this.stroke);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Shadowable polygon = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            polygon.setDeltaShadow(4.0);
        }
        ug = ug.apply(new UChangeBackColor(this.backgroundColor)).apply(new UChangeColor(this.borderColor));
        ug = this.applyStroke(ug);
        ug.draw(polygon);
        this.textBlock.drawU(ug.apply(new UTranslate(6.0, 5.0)));
    }

    private Shadowable getPolygonNormal(StringBounder stringBounder) {
        double height = this.getTextHeight(stringBounder);
        double width = this.getTextWidth(stringBounder);
        return new URectangle(width, height, this.cornersize, this.cornersize);
    }
}

