/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postit;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.postit.Area;
import net.sourceforge.plantuml.postit.PostIt;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public class PostItDiagram
extends UmlDiagram {
    private final Area defaultArea = new Area('\u0000', null);
    private final Map<String, PostIt> postIts = new HashMap<String, PostIt>();
    private int width = 800;

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return null;
    }

    @Override
    protected final ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        UGraphic ug = this.createImage(fileFormatOption);
        this.drawU(ug);
        if (ug instanceof UGraphicG2d) {
            BufferedImage im = ((UGraphicG2d)ug).getBufferedImage();
            PngIO.write((RenderedImage)im, os, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getDpi(fileFormatOption));
        } else if (ug instanceof UGraphicSvg) {
            UGraphicSvg svg = (UGraphicSvg)ug;
            svg.createXml(os, fileFormatOption.isWithMetadata() ? this.getMetadata() : null);
        } else if (ug instanceof UGraphicEps) {
            UGraphicEps eps = (UGraphicEps)ug;
            os.write(eps.getEPSCode().getBytes());
        }
        return new ImageDataSimple();
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Board of post-it");
    }

    public Area getDefaultArea() {
        return this.defaultArea;
    }

    public Area createArea(char id) {
        throw new UnsupportedOperationException();
    }

    public PostIt createPostIt(String id, Display text) {
        if (this.postIts.containsKey(id)) {
            throw new IllegalArgumentException();
        }
        PostIt postIt = new PostIt(id, text);
        this.postIts.put(id, postIt);
        this.getDefaultArea().add(postIt);
        return postIt;
    }

    void drawU(UGraphic ug) {
        this.getDefaultArea().drawU(ug, this.width);
    }

    private UGraphic createImage(FileFormatOption fileFormatOption) {
        Color backColor = this.getSkinParam().getColorMapper().getMappedColor(this.getSkinParam().getBackgroundColor());
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            double height = this.getDefaultArea().heightWhenWidthIs(this.width, fileFormatOption.getDefaultStringBounder());
            EmptyImageBuilder builder = new EmptyImageBuilder((double)this.width, height, backColor);
            Graphics2D graphics2D = builder.getGraphics2D();
            double dpiFactor = this.getDpiFactor(fileFormatOption);
            UGraphicG2d result = new UGraphicG2d(new ColorMapperIdentity(), graphics2D, dpiFactor);
            result.setBufferedImage(builder.getBufferedImage());
            return result;
        }
        throw new UnsupportedOperationException();
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

