/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.sourceforge.plantuml.preproc.DefineVariable;

public class Variables {
    private final List<DefineVariable> all = new ArrayList<DefineVariable>();

    public void add(DefineVariable var) {
        this.all.add(var);
    }

    public int countDefaultValue() {
        int result = 0;
        for (DefineVariable var : this.all) {
            if (var.getDefaultValue() == null) continue;
            ++result;
        }
        return result;
    }

    public Variables removeSomeDefaultValues(int nb) {
        if (nb == 0) {
            return this;
        }
        Variables result = new Variables();
        for (DefineVariable v : this.all) {
            if (v.getDefaultValue() != null && nb > 0) {
                result.add(v.removeDefault());
                --nb;
                continue;
            }
            result.add(v);
        }
        if (nb != 0) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public String applyOn(String line, String fonctionName, String newValue) {
        StringBuilder regex = new StringBuilder("\\b" + fonctionName + "\\(");
        List<DefineVariable> variables = this.all;
        boolean appended = false;
        for (int j = 0; j < variables.size(); ++j) {
            DefineVariable variable = variables.get(j);
            String varName = variable.getName();
            String var2 = "(##" + varName + "\\b)|(\\b" + varName + "##)|(\\b" + varName + "\\b)";
            if (variable.getDefaultValue() == null) {
                regex.append("(?:(?:\\s*\"([^\"]*)\"\\s*)|(?:\\s*'([^']*)'\\s*)|\\s*((?:\\([^()]*\\)|[^,'\"])*?))");
                int i = 1 + 3 * j;
                newValue = newValue.replaceAll(var2, "\\$" + i + "\\$" + (i + 1) + "\\$" + (i + 2));
                regex.append(",");
                appended = true;
                continue;
            }
            newValue = newValue.replaceAll(var2, Matcher.quoteReplacement(variable.getDefaultValue()));
        }
        if (appended) {
            regex.setLength(regex.length() - 1);
        }
        regex.append("\\)");
        line = line.replaceAll(regex.toString(), newValue);
        return line;
    }
}

