/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandComment;
import net.sourceforge.plantuml.command.CommandMultilinesComment;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.UmlDiagramFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.NaturalCommand;
import net.sourceforge.plantuml.project3.NaturalCommandAnd;
import net.sourceforge.plantuml.project3.NaturalCommandAndAnd;
import net.sourceforge.plantuml.project3.SubjectDayOfWeek;
import net.sourceforge.plantuml.project3.SubjectPattern;
import net.sourceforge.plantuml.project3.SubjectProject;
import net.sourceforge.plantuml.project3.SubjectTask;
import net.sourceforge.plantuml.project3.VerbPattern;

public class GanttDiagramFactory
extends UmlDiagramFactory {
    private List<SubjectPattern> subjects() {
        return Arrays.asList(new SubjectTask(), new SubjectProject(), new SubjectDayOfWeek());
    }

    public GanttDiagramFactory() {
        super(DiagramType.UML);
    }

    @Override
    protected List<Command> createCommands() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(new CommandNope());
        cmds.add(new CommandComment());
        cmds.add(new CommandMultilinesComment());
        for (Command cmd : this.getLanguageCommands()) {
            cmds.add(cmd);
        }
        return cmds;
    }

    private Collection<Command> getLanguageCommands() {
        Collection<VerbPattern> verbs;
        ArrayList<Command> result = new ArrayList<Command>();
        for (SubjectPattern subject : this.subjects()) {
            for (VerbPattern verb : subject.getVerbs()) {
                for (ComplementPattern complement : verb.getComplements()) {
                    result.add(NaturalCommand.create(subject, verb, complement));
                }
            }
        }
        for (SubjectPattern subject : this.subjects()) {
            verbs = subject.getVerbs();
            for (VerbPattern verb1 : verbs) {
                for (VerbPattern verb2 : verbs) {
                    if (verb1 == verb2) continue;
                    for (ComplementPattern complement1 : verb1.getComplements()) {
                        for (ComplementPattern complement2 : verb2.getComplements()) {
                            result.add(NaturalCommandAnd.create(subject, verb1, complement1, verb2, complement2));
                        }
                    }
                }
            }
        }
        for (SubjectPattern subject : this.subjects()) {
            verbs = subject.getVerbs();
            for (VerbPattern verb1 : verbs) {
                for (VerbPattern verb2 : verbs) {
                    for (VerbPattern verb3 : verbs) {
                        if (verb1 == verb2 || verb1 == verb3 || verb2 == verb3) continue;
                        for (ComplementPattern complement1 : verb1.getComplements()) {
                            for (ComplementPattern complement2 : verb2.getComplements()) {
                                for (ComplementPattern complement3 : verb3.getComplements()) {
                                    result.add(NaturalCommandAndAnd.create(subject, verb1, complement1, verb2, complement2, verb3, complement3));
                                }
                            }
                        }
                    }
                }
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public GanttDiagram createEmptyDiagram() {
        return new GanttDiagram();
    }
}

