/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Display;

public class TaskCode {
    private final List<String> hierarchy;

    public TaskCode(String code) {
        this.hierarchy = Arrays.asList(code.split("/"));
    }

    public boolean startsWith(TaskCode other) {
        if (other.hierarchy.size() > this.hierarchy.size()) {
            return false;
        }
        assert (other.hierarchy.size() <= this.hierarchy.size());
        List<String> sub = this.hierarchy.subList(0, other.hierarchy.size());
        return sub.equals(other.hierarchy);
    }

    private TaskCode(List<String> hierarchy) {
        this.hierarchy = hierarchy;
    }

    public TaskCode truncateHierarchy(int size) {
        return new TaskCode(this.hierarchy.subList(0, size));
    }

    public int hashCode() {
        return this.hierarchy.hashCode();
    }

    public boolean equals(Object arg) {
        TaskCode other = (TaskCode)arg;
        return this.hierarchy.equals(other.hierarchy);
    }

    public String toString() {
        return this.hierarchy.toString();
    }

    public Display getSimpleDisplay() {
        String last = this.hierarchy.get(this.hierarchy.size() - 1);
        return Display.getWithNewlines(last);
    }

    public int getHierarchySize() {
        return this.hierarchy.size();
    }
}

