/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.sequencediagram.NoteOnMessage;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ArrowConfiguration;

public abstract class AbstractMessage
implements EventWithDeactivate {
    private final Display label;
    private final ArrowConfiguration arrowConfiguration;
    private final Set<LifeEventType> lifeEventsType = EnumSet.noneOf(LifeEventType.class);
    private Url url = null;
    private final String messageNumber;
    private boolean parallel = false;
    private List<NoteOnMessage> noteOnMessages = new ArrayList<NoteOnMessage>();
    private boolean firstIsActivate = false;
    private final Set<Participant> noActivationAuthorized2 = new HashSet<Participant>();
    private double posYendLevel;
    private double posYstartLevel;

    public AbstractMessage(Display label, ArrowConfiguration arrowConfiguration, String messageNumber) {
        this.label = label;
        this.arrowConfiguration = arrowConfiguration;
        this.messageNumber = messageNumber;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }

    public void goParallel() {
        this.parallel = true;
    }

    @Override
    public boolean isParallel() {
        return this.parallel;
    }

    @Override
    public final Url getUrl() {
        if (this.url == null) {
            for (NoteOnMessage n : this.noteOnMessages) {
                if (n.getUrlNote() == null) continue;
                return n.getUrlNote();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        for (NoteOnMessage n : this.noteOnMessages) {
            if (!n.hasUrl()) continue;
            return true;
        }
        if (this.label != null && this.label.hasUrl()) {
            return true;
        }
        return this.getUrl() != null;
    }

    @Override
    public final boolean addLifeEvent(LifeEvent lifeEvent) {
        lifeEvent.setMessage(this);
        this.lifeEventsType.add(lifeEvent.getType());
        if (this.lifeEventsType.size() == 1 && this.isActivate()) {
            this.firstIsActivate = true;
        }
        if (lifeEvent.getType() == LifeEventType.ACTIVATE && this.noActivationAuthorized2.contains(lifeEvent.getParticipant())) {
            return false;
        }
        if (lifeEvent.getType() == LifeEventType.DEACTIVATE || lifeEvent.getType() == LifeEventType.DESTROY) {
            this.noActivationAuthorized2.add(lifeEvent.getParticipant());
        }
        return true;
    }

    public final boolean isCreate() {
        return this.lifeEventsType.contains((Object)LifeEventType.CREATE);
    }

    public boolean isActivate() {
        return this.lifeEventsType.contains((Object)LifeEventType.ACTIVATE);
    }

    public boolean isDeactivate() {
        return this.lifeEventsType.contains((Object)LifeEventType.DEACTIVATE);
    }

    private boolean isDeactivateOrDestroy() {
        return this.lifeEventsType.contains((Object)LifeEventType.DEACTIVATE) || this.lifeEventsType.contains((Object)LifeEventType.DESTROY);
    }

    public final boolean isActivateAndDeactive() {
        return this.firstIsActivate && this.isDeactivateOrDestroy();
    }

    public final Display getLabel() {
        return this.label;
    }

    public final Display getLabelNumbered() {
        if (this.getMessageNumber() == null) {
            return this.getLabel();
        }
        Display result = Display.empty();
        result = result.add(new MessageNumber(this.getMessageNumber()));
        result = result.addAll(this.getLabel());
        return result;
    }

    public final ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }

    public final List<NoteOnMessage> getNoteOnMessages() {
        return this.noteOnMessages;
    }

    public final void setNote(Display strings, NotePosition notePosition, NoteStyle noteStyle, String backcolor, Url url) {
        if (notePosition != NotePosition.LEFT && notePosition != NotePosition.RIGHT) {
            throw new IllegalArgumentException();
        }
        this.noteOnMessages.add(new NoteOnMessage(strings, this.overideNotePosition(notePosition), noteStyle, backcolor, url));
    }

    protected NotePosition overideNotePosition(NotePosition notePosition) {
        return notePosition;
    }

    public final String getMessageNumber() {
        return this.messageNumber;
    }

    public abstract boolean compatibleForCreate(Participant var1);

    public abstract boolean isSelfMessage();

    public double getPosYstartLevel() {
        return this.posYstartLevel;
    }

    public void setPosYstartLevel(double posYstartLevel) {
        this.posYstartLevel = posYstartLevel;
    }

    @Override
    public void setPosYendLevel(double posYendLevel) {
        this.posYendLevel = posYendLevel;
    }

    @Override
    public double getPosYendLevel() {
        return this.posYendLevel;
    }
}

