/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandActivate
extends SingleLineCommand<SequenceDiagram> {
    public CommandActivate() {
        super("(?i)^(activate|deactivate|destroy|create)[%s]+([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*(#\\w+)?(?:[%s]+(#\\w+))?$");
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, List<String> arg) {
        HtmlColor lineColor;
        HtmlColor backColor;
        LifeEventType type = LifeEventType.valueOf(StringUtils.goUpperCase(arg.get(0)));
        Participant p = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get(1)));
        String error = diagram.activate(p, type, backColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get(2)), lineColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get(3)));
        if (error == null) {
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error(error);
    }
}

