/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.Scalable;
import net.sourceforge.plantuml.ugraphic.UShape;

public class ULine
extends AbstractShadowable
implements Scalable {
    private final double dx;
    private final double dy;

    @Override
    public UShape getScaled(double scale) {
        if (scale == 1.0) {
            return this;
        }
        ULine result = new ULine(this.dx * scale, this.dy * scale);
        ((AbstractShadowable)result).setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public ULine(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public String toString() {
        return "ULine dx=" + this.dx + " dy=" + this.dy;
    }

    public double getDX() {
        return this.dx;
    }

    public double getDY() {
        return this.dy;
    }

    public double getLength() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }
}

