/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.editorLayout;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.Nullable;

abstract class BaseChangeSplitLayoutAction
extends AnAction
implements DumbAware,
Toggleable {
    @Nullable
    private final SplitFileEditor.SplitEditorLayout myLayoutToSet;

    protected BaseChangeSplitLayoutAction(@Nullable SplitFileEditor.SplitEditorLayout layoutToSet) {
        this.myLayoutToSet = layoutToSet;
    }

    public void update(AnActionEvent e) {
        SplitFileEditor splitFileEditor = MarkdownActionUtil.findSplitEditor(e);
        e.getPresentation().setEnabled(splitFileEditor != null);
        if (this.myLayoutToSet != null && splitFileEditor != null) {
            e.getPresentation().putClientProperty("selected", (Object)(splitFileEditor.getCurrentEditorLayout() == this.myLayoutToSet ? 1 : 0));
        }
    }

    public void actionPerformed(AnActionEvent e) {
        SplitFileEditor splitFileEditor = MarkdownActionUtil.findSplitEditor(e);
        if (splitFileEditor != null) {
            if (this.myLayoutToSet == null) {
                splitFileEditor.triggerLayoutChange();
            } else {
                splitFileEditor.triggerLayoutChange(this.myLayoutToSet, true);
                e.getPresentation().putClientProperty("selected", (Object)true);
            }
        }
    }
}

