/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.javafx.MarkdownJavaFxHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

public class PreviewStaticServer
extends HttpRequestHandler {
    public static final String INLINE_CSS_FILENAME = "inline.css";
    private static final String PREFIX = "/api/markdown-preview/";
    @Nullable
    private String myInlineStyle = null;
    private long myInlineStyleTimestamp = 0L;

    public static PreviewStaticServer getInstance() {
        return (PreviewStaticServer)((Object)HttpRequestHandler.Companion.getEP_NAME().findExtension(PreviewStaticServer.class));
    }

    @NotNull
    public static String createCSP(@NotNull List<String> scripts, @NotNull List<String> styles) {
        if (scripts == null) {
            PreviewStaticServer.$$$reportNull$$$0(0);
        }
        if (styles == null) {
            PreviewStaticServer.$$$reportNull$$$0(1);
        }
        String string = "default-src 'none'; script-src " + StringUtil.join(scripts, (String)" ") + "; style-src https: " + StringUtil.join(styles, (String)" ") + "; img-src *; connect-src 'none'; font-src *; object-src 'none'; media-src 'none'; child-src 'none';";
        if (string == null) {
            PreviewStaticServer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getStaticUrl(@NotNull String staticPath) {
        if (staticPath == null) {
            PreviewStaticServer.$$$reportNull$$$0(3);
        }
        String string = "http://localhost:" + BuiltInServerManager.getInstance().getPort() + PREFIX + staticPath;
        if (string == null) {
            PreviewStaticServer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getScriptUrl(@NotNull String scriptFileName) {
        if (scriptFileName == null) {
            PreviewStaticServer.$$$reportNull$$$0(5);
        }
        String string = PreviewStaticServer.getStaticUrl("scripts/" + scriptFileName);
        if (string == null) {
            PreviewStaticServer.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getStyleUrl(@NotNull String scriptFileName) {
        if (scriptFileName == null) {
            PreviewStaticServer.$$$reportNull$$$0(7);
        }
        String string = PreviewStaticServer.getStaticUrl("styles/" + scriptFileName);
        if (string == null) {
            PreviewStaticServer.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setInlineStyle(@Nullable String inlineStyle) {
        this.myInlineStyle = inlineStyle;
        this.myInlineStyleTimestamp = System.currentTimeMillis();
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            PreviewStaticServer.$$$reportNull$$$0(9);
        }
        return super.isSupported(request) && request.uri().startsWith(PREFIX);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        String path;
        if (urlDecoder == null) {
            PreviewStaticServer.$$$reportNull$$$0(10);
        }
        if (request == null) {
            PreviewStaticServer.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PreviewStaticServer.$$$reportNull$$$0(12);
        }
        if (!(path = urlDecoder.path()).startsWith(PREFIX)) {
            throw new IllegalStateException("prefix should have been checked by #isSupported");
        }
        String payLoad = path.substring(PREFIX.length());
        List typeAndName = StringUtil.split((String)payLoad, (String)"/");
        if (typeAndName.size() != 2) {
            return false;
        }
        String contentType = (String)typeAndName.get(0);
        String fileName = (String)typeAndName.get(1);
        if ("scripts".equals(contentType) && MarkdownHtmlPanel.SCRIPTS.contains(fileName)) {
            PreviewStaticServer.sendResource((HttpRequest)request, context.channel(), MarkdownJavaFxHtmlPanel.class, fileName);
        } else if ("styles".equals(contentType) && MarkdownHtmlPanel.STYLES.contains(fileName)) {
            if (INLINE_CSS_FILENAME.equals(fileName)) {
                this.sendInlineStyle((HttpRequest)request, context.channel());
            } else {
                PreviewStaticServer.sendResource((HttpRequest)request, context.channel(), MarkdownCssSettings.class, fileName);
            }
        } else {
            return false;
        }
        return true;
    }

    private void sendInlineStyle(@NotNull HttpRequest request, @NotNull Channel channel) {
        HttpResponse response;
        if (request == null) {
            PreviewStaticServer.$$$reportNull$$$0(13);
        }
        if (channel == null) {
            PreviewStaticServer.$$$reportNull$$$0(14);
        }
        if ((response = FileResponses.INSTANCE.prepareSend(request, channel, this.myInlineStyleTimestamp, INLINE_CSS_FILENAME, (HttpHeaders)EmptyHttpHeaders.INSTANCE)) == null) {
            return;
        }
        Responses.addKeepAliveIfNeed((HttpResponse)response, (HttpRequest)request);
        if (this.myInlineStyle == null) {
            Responses.send((HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (Channel)channel, (HttpRequest)request);
            return;
        }
        channel.write((Object)response);
        if (request.method() != HttpMethod.HEAD) {
            channel.write((Object)new ChunkedStream((InputStream)new ByteArrayInputStream(this.myInlineStyle.getBytes(CharsetToolkit.UTF8_CHARSET))));
        }
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendResource(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Class<?> clazz, @NotNull String resourceName) {
        String fileName;
        HttpResponse response;
        if (request == null) {
            PreviewStaticServer.$$$reportNull$$$0(15);
        }
        if (channel == null) {
            PreviewStaticServer.$$$reportNull$$$0(16);
        }
        if (clazz == null) {
            PreviewStaticServer.$$$reportNull$$$0(17);
        }
        if (resourceName == null) {
            PreviewStaticServer.$$$reportNull$$$0(18);
        }
        if ((response = FileResponses.INSTANCE.prepareSend(request, channel, 0L, fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1), (HttpHeaders)EmptyHttpHeaders.INSTANCE)) == null) {
            return;
        }
        Responses.addKeepAliveIfNeed((HttpResponse)response, (HttpRequest)request);
        try (InputStream resource2 = clazz.getResourceAsStream(resourceName);){
            if (resource2 == null) {
                Responses.send((HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (Channel)channel, (HttpRequest)request);
                return;
            }
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                channel.write((Object)new ChunkedStream(resource2));
            }
        }
        catch (IOException resource2) {
            // empty catch block
        }
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scripts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styles";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticPath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFileName";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlDecoder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCSP";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCSP";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStaticUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getScriptUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStyleUrl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sendInlineStyle";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sendResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

