/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ThrowableConvertor;
import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.CancellableGithubConnection;
import org.jetbrains.plugins.github.api.GithubApiTaskExecutor;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.util.GithubAuthData;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JQ\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\"\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000e0\fj\b\u0012\u0004\u0012\u0002H\u0006`\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J=\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\t\u001a\u00020\n2\"\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000e0\fj\b\u0012\u0004\u0012\u0002H\u0006`\u000f\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor;", "", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "(Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;)V", "execute", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "task", "Lcom/intellij/util/ThrowableConvertor;", "Lorg/jetbrains/plugins/github/api/GithubConnection;", "Ljava/io/IOException;", "Lorg/jetbrains/plugins/github/api/GithubTask;", "silentFailOnMissingToken", "", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lcom/intellij/util/ThrowableConvertor;Z)Ljava/lang/Object;", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lcom/intellij/util/ThrowableConvertor;)Ljava/lang/Object;", "Companion", "intellij.vcs.github"})
public final class GithubApiTaskExecutor {
    private final GithubAuthenticationManager authenticationManager;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubAccount account, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task, boolean silentFailOnMissingToken) throws IOException {
        Object object;
        Closeable closeable;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        if (silentFailOnMissingToken) {
            string = this.authenticationManager.getTokenForAccount$intellij_vcs_github(account);
            if (string == null) {
                throw (Throwable)new GithubMissingTokenException(account);
            }
        } else {
            string = GithubAuthenticationManager.getOrRequestTokenForAccount$intellij_vcs_github$default(this.authenticationManager, account, null, null, (Function0)new Function0<ModalityState>(indicator){
                final /* synthetic */ ProgressIndicator $indicator;

                @NotNull
                public final ModalityState invoke() {
                    ModalityState modalityState = this.$indicator.getModalityState();
                    Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"indicator.modalityState");
                    return modalityState;
                }
                {
                    this.$indicator = progressIndicator;
                    super(0);
                }
            }, 6, null);
            if (string == null) {
                throw (Throwable)new ProcessCanceledException((Throwable)new GithubMissingTokenException(account));
            }
        }
        String token2 = string;
        GithubAuthData githubAuthData = GithubAuthData.createTokenAuth(account.getServer().toString(), token2);
        Intrinsics.checkExpressionValueIsNotNull((Object)githubAuthData, (String)"GithubAuthData.createTok\u2026server.toString(), token)");
        CancellableGithubConnection $receiver = closeable = new CancellableGithubConnection(indicator, githubAuthData);
        $receiver.setAccount(account);
        closeable = closeable;
        ThrowableConvertor<GithubConnection, T, IOException> throwableConvertor = task;
        Throwable throwable = null;
        try {
            GithubConnection p1 = closeable;
            object = throwableConvertor.convert((Object)p1);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ Object execute$default(GithubApiTaskExecutor githubApiTaskExecutor, ProgressIndicator progressIndicator, GithubAccount githubAccount, ThrowableConvertor throwableConvertor, boolean bl, int n, Object object) throws IOException {
        if ((n & 8) != 0) {
            bl = false;
        }
        return githubApiTaskExecutor.execute(progressIndicator, githubAccount, throwableConvertor, bl);
    }

    @JvmOverloads
    public final <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubAccount account, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        return (T)GithubApiTaskExecutor.execute$default(this, indicator, account, task, false, 8, null);
    }

    public final <T> T execute(@NotNull GithubAccount account, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        return this.execute((ProgressIndicator)new EmptyProgressIndicator(), account, task, true);
    }

    public GithubApiTaskExecutor(@NotNull GithubAuthenticationManager authenticationManager) {
        Intrinsics.checkParameterIsNotNull((Object)authenticationManager, (String)"authenticationManager");
        this.authenticationManager = authenticationManager;
    }

    @JvmStatic
    public static final <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        return Companion.execute(indicator, server, task);
    }

    @JvmStatic
    public static final <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull String token2, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        return Companion.execute(indicator, server, token2, task);
    }

    @JvmStatic
    public static final <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull String login2, @NotNull char[] password, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        return Companion.execute(indicator, server, login2, password, task);
    }

    @JvmStatic
    @NotNull
    public static final GithubApiTaskExecutor getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JW\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\u00100\u000ej\b\u0012\u0004\u0012\u0002H\u0004`\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012JO\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\u00100\u000ej\b\u0012\u0004\u0012\u0002H\u0004`\u0011H\u0007\u00a2\u0006\u0002\u0010\u0014JG\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\u00100\u000ej\b\u0012\u0004\u0012\u0002H\u0004`\u0011H\u0007\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0007J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000fH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor$Companion;", "", "()V", "execute", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "login", "", "password", "", "task", "Lcom/intellij/util/ThrowableConvertor;", "Lorg/jetbrains/plugins/github/api/GithubConnection;", "Ljava/io/IOException;", "Lorg/jetbrains/plugins/github/api/GithubTask;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;[CLcom/intellij/util/ThrowableConvertor;)Ljava/lang/Object;", "token", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;Lcom/intellij/util/ThrowableConvertor;)Ljava/lang/Object;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubServerPath;Lcom/intellij/util/ThrowableConvertor;)Ljava/lang/Object;", "getInstance", "Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor;", "getTwoFactorAuthData", "Lorg/jetbrains/plugins/github/util/GithubAuthData;", "originalAuth", "connection", "intellij.vcs.github"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull(task, (String)"task");
            GithubAuthData githubAuthData = GithubAuthData.createAnonymous(server.toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)githubAuthData, (String)"GithubAuthData.createAnonymous(server.toString())");
            Closeable closeable = new CancellableGithubConnection(indicator, githubAuthData);
            ThrowableConvertor<GithubConnection, T, IOException> throwableConvertor = task;
            Throwable throwable = null;
            try {
                GithubConnection p1 = (GithubConnection)((Object)closeable);
                object = throwableConvertor.convert((Object)p1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull String token2, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)token2, (String)"token");
            Intrinsics.checkParameterIsNotNull(task, (String)"task");
            GithubAuthData githubAuthData = GithubAuthData.createTokenAuth(server.toString(), token2);
            Intrinsics.checkExpressionValueIsNotNull((Object)githubAuthData, (String)"GithubAuthData.createTok\u2026server.toString(), token)");
            Closeable closeable = new CancellableGithubConnection(indicator, githubAuthData);
            ThrowableConvertor<GithubConnection, T, IOException> throwableConvertor = task;
            Throwable throwable = null;
            try {
                GithubConnection p1 = (GithubConnection)((Object)closeable);
                object = throwableConvertor.convert((Object)p1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull String login2, @NotNull char[] password, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
            GithubAuthData basicAuth;
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            Intrinsics.checkParameterIsNotNull(task, (String)"task");
            String string = login2;
            String string2 = server.toString();
            String string3 = new String(password);
            GithubAuthData githubAuthData = basicAuth = GithubAuthData.createBasicAuth(string2, string, string3);
            Intrinsics.checkExpressionValueIsNotNull((Object)githubAuthData, (String)"basicAuth");
            Closeable closeable = new CancellableGithubConnection(indicator, githubAuthData);
            Throwable throwable = null;
            try {
                Object object;
                CancellableGithubConnection connection = (CancellableGithubConnection)closeable;
                try {
                    object = task.convert((Object)connection);
                }
                catch (GithubTwoFactorAuthenticationException e) {
                    Object object2;
                    GithubAuthData twoFactorAuthData = Companion.getTwoFactorAuthData(indicator, basicAuth, connection);
                    Closeable closeable2 = new CancellableGithubConnection(indicator, twoFactorAuthData);
                    ThrowableConvertor<GithubConnection, T, IOException> throwableConvertor = task;
                    Throwable throwable2 = null;
                    try {
                        GithubConnection p1 = (GithubConnection)((Object)closeable2);
                        object2 = throwableConvertor.convert((Object)p1);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    object = object2;
                }
                Object object3 = object;
                return (T)object3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final GithubAuthData getTwoFactorAuthData(ProgressIndicator indicator, GithubAuthData originalAuth, GithubConnection connection) {
            GithubApiUtil.askForTwoFactorCodeSMS(connection);
            String code2 = (String)ActionsKt.invokeAndWaitIfNeed((ModalityState)indicator.getModalityState(), (Function0)getTwoFactorAuthData.code.1.INSTANCE);
            if (code2 == null) {
                throw (Throwable)new GithubOperationCanceledException("Can't get two factor authentication code");
            }
            GithubAuthData githubAuthData = originalAuth.copyWithTwoFactorCode(code2);
            Intrinsics.checkExpressionValueIsNotNull((Object)githubAuthData, (String)"originalAuth.copyWithTwoFactorCode(code)");
            return githubAuthData;
        }

        @JvmStatic
        @NotNull
        public final GithubApiTaskExecutor getInstance() {
            Object object = ServiceManager.getService(GithubApiTaskExecutor.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (GithubApiTaskExecutor)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

