/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.ui.GithubSelectForkPanel;
import org.jetbrains.plugins.github.util.GithubNotifications;

public class GithubSelectForkDialog
extends DialogWrapper {
    @NotNull
    private final GithubSelectForkPanel myPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Convertor<String, GithubCreatePullRequestWorker.ForkInfo> myCheckFork;
    private GithubCreatePullRequestWorker.ForkInfo mySelectedFork;

    public GithubSelectForkDialog(@NotNull Project project, @Nullable List<GithubFullPath> forks, @NotNull Convertor<String, GithubCreatePullRequestWorker.ForkInfo> checkFork) {
        if (project == null) {
            GithubSelectForkDialog.$$$reportNull$$$0(0);
        }
        if (checkFork == null) {
            GithubSelectForkDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myCheckFork = checkFork;
        this.myPanel = new GithubSelectForkPanel();
        if (forks != null) {
            this.myPanel.setUsers(ContainerUtil.map(forks, GithubFullPath::getUser));
        }
        this.setTitle("Select Base Fork Repository");
        this.init();
    }

    protected void doOKAction() {
        GithubCreatePullRequestWorker.ForkInfo fork = (GithubCreatePullRequestWorker.ForkInfo)this.myCheckFork.convert((Object)this.myPanel.getUser());
        if (fork == null) {
            GithubNotifications.showErrorDialog(this.myProject, "Can't Find Repository", "Can't find fork for selected user");
        } else {
            this.mySelectedFork = fork;
            super.doOKAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @NotNull
    public GithubCreatePullRequestWorker.ForkInfo getPath() {
        GithubCreatePullRequestWorker.ForkInfo forkInfo = this.mySelectedFork;
        if (forkInfo == null) {
            GithubSelectForkDialog.$$$reportNull$$$0(2);
        }
        return forkInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkFork";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/ui/GithubSelectForkDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/ui/GithubSelectForkDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

